<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Frontoffice.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Frontoffice
 * @description     : Manage front office.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Frontoffice extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Frontoffice_Model', 'frontoffice', true);
    }


    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "visitors purpose List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('frontoffice/source/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->frontoffice->get_visitor_purpose_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['visitor_purposes'] = $this->frontoffice->get_visitor_purpose_list($config['per_page'], $offset, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('visitor') . ' ' . $this->lang->line('purpose') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('front_office/purpose/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new Visitors Purpose" user interface
     *                    and process to store "visitor_purposes" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add() {

        check_permission(ADD);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $insert_id = $this->frontoffice->insert('visitor_purposes', $data);
                if ($insert_id) {
                    create_log('Has been created a Visitor Purpose : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('hospital/frontoffice');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('hospital/frontoffice/add');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('visitor') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('front_office/purpose/add', $this->data);
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load "Edit new Visitor Purpose" user interface
     *                    and process to store "visitor_purposes" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function edit($id = NULL) {

        check_permission(EDIT);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $updated = $this->frontoffice->update('visitor_purposes', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a Visitor Purpose : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('hospital/frontoffice');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('hospital/frontoffice/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data['purpose'] = $this->frontoffice->get_single('visitor_purposes', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['purpose'] = $this->frontoffice->get_single('visitor_purposes', array('id' => $id));
                if (!$this->data['purpose']) {
                    redirect('hospital/frontoffice');
                }
            }
        }

        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('purpose') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('front_office/purpose/edit', $this->data);
    }

    /*****************Function name**********************************
     * @type            : Function
     * @function name   : name
     * @description     : Unique check for "Visitor Purpose Name" data/value
     *
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function name() {
        if ($this->input->post('id') == '') {
            $purpose = $this->frontoffice->duplicate_check($this->input->post('name'));
            if ($purpose) {
                $this->form_validation->set_message('name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('id') != '') {
            $purpose = $this->frontoffice->duplicate_check($this->input->post('name'), $this->input->post('id'));
            if ($purpose) {
                $this->form_validation->set_message('name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "visitor_purposes" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('hospital/frontoffice');
        }

        $purpose = $this->frontoffice->get_single('visitor_purposes', array('id' => $id));

        if ($this->frontoffice->delete('visitor_purposes', array('id' => $id))) {
            create_log('Has been deleted a Visitor Purpose : ' . $purpose->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }


    /*****************Function complainttype**********************************
     * @type            : Function
     * @function name   : complainttype
     * @description     : Load "complaint type List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function complainttype() {

        check_permission(VIEW);

        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('frontoffice/complainttype/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->frontoffice->get_complaint_type_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['complaint_types'] = $this->frontoffice->get_complaint_type_list($config['per_page'], $offset, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('complaint') . ' ' . $this->lang->line('type') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('front_office/complaint_type/index', $this->data);
    }

    /*****************Function add_complainttype**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new Complaint Type" user interface
     *                    and process to store "complaint_types" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add_complainttype() {

        check_permission(ADD);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_complaint_type');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $insert_id = $this->frontoffice->insert('complaint_types', $data);
                if ($insert_id) {
                    create_log('Has been created a Complaint Type : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('hospital/frontoffice/complainttype');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('hospital/frontoffice/add_complainttype');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('complaint') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('front_office/complaint_type/add', $this->data);
    }

    /*****************Function edit_complainttype**********************************
     * @type            : Function
     * @function name   : edit_complainttype
     * @description     : Load "Edit new Complaint Type" user interface
     *                    and process to store "complaint_types" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function edit_complainttype($id = NULL) {

        check_permission(EDIT);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_complaint_type');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $updated = $this->frontoffice->update('complaint_types', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a Complaint Type : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('hospital/frontoffice/complainttype');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('hospital/frontoffice/edit_complainttype/' . $this->input->post('id'));
                }
            } else {
                $this->data['complaint'] = $this->frontoffice->get_single('complaint_types', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['complaint'] = $this->frontoffice->get_single('complaint_types', array('id' => $id));
                if (!$this->data['complaint']) {
                    redirect('hospital/frontoffice/complainttype');
                }
            }
        }

        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('complaint') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('front_office/complaint_type/edit', $this->data);
    }

    /*****************Function complaint_type**********************************
     * @type            : Function
     * @function name   : complaint_type
     * @description     : Unique check for "Complaint Type Name" data/value
     *
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function complaint_type() {
        if ($this->input->post('id') == '') {
            $complaint_type = $this->frontoffice->duplicate_check_complaint_type($this->input->post('name'));
            if ($complaint_type) {
                $this->form_validation->set_message('complaint_type', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('id') != '') {
            $complaint_type = $this->frontoffice->duplicate_check_complaint_type($this->input->post('name'), $this->input->post('id'));
            if ($complaint_type) {
                $this->form_validation->set_message('complaint_type', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /*****************Function delete_complainttype**********************************
     * @type            : Function
     * @function name   : delete_complainttype
     * @description     : delete "complaint_types" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete_complainttype($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('hospital/frontoffice/complainttype');
        }

        $complaint_type = $this->frontoffice->get_single('complaint_types', array('id' => $id));

        if ($this->frontoffice->delete('complaint_types', array('id' => $id))) {
            create_log('Has been deleted a Complaint Type : ' . $complaint_type->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }


    /*****************Function source**********************************
     * @type            : Function
     * @function name   : source
     * @description     : Load "Source List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function source() {

        check_permission(VIEW);

        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('frontoffice/source/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->frontoffice->get_source_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['sources'] = $this->frontoffice->get_source_list($config['per_page'], $offset, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('source') . ' ' . $this->lang->line('list') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('front_office/source/index', $this->data);
    }

    /*****************Function add_source**********************************
     * @type            : Function
     * @function name   : add_source
     * @description     : Load "Add new Source" user interface
     *                    and process to store "sources" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add_source() {

        check_permission(ADD);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_source_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $insert_id = $this->frontoffice->insert('sources', $data);
                if ($insert_id) {
                    create_log('Has been created a Source : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('hospital/frontoffice/source');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('hospital/frontoffice/add_source');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('source') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('front_office/source/add', $this->data);
    }

    /*****************Function edit_source**********************************
     * @type            : Function
     * @function name   : edit_source
     * @description     : Load "Edit new Source" user interface
     *                    and process to store "sources" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function edit_source($id = NULL) {

        check_permission(EDIT);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_source_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $updated = $this->frontoffice->update('sources', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a Source : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('hospital/frontoffice/source');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('hospital/frontoffice/edit_source/' . $this->input->post('id'));
                }
            } else {
                $this->data['source'] = $this->frontoffice->get_single('sources', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['source'] = $this->frontoffice->get_single('sources', array('id' => $id));
                if (!$this->data['source']) {
                    redirect('hospital/frontoffice/source');
                }
            }
        }

        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('source') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('front_office/source/edit', $this->data);
    }

    /*****************Function source_name**********************************
     * @type            : Function
     * @function name   : source_name
     * @description     : Unique check for "Source Name" data/value
     *
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function source_name() {
        if ($this->input->post('id') == '') {
            $source = $this->frontoffice->duplicate_check_source($this->input->post('name'));
            if ($source) {
                $this->form_validation->set_message('source_name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('id') != '') {
            $source = $this->frontoffice->duplicate_check_source($this->input->post('name'), $this->input->post('id'));
            if ($source) {
                $this->form_validation->set_message('source_name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /*****************Function delete_source**********************************
     * @type            : Function
     * @function name   : delete_source
     * @description     : delete "sources" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete_source($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('hospital/frontoffice/source');
        }

        $source = $this->frontoffice->get_single('sources', array('id' => $id));

        if ($this->frontoffice->delete('sources', array('id' => $id))) {
            create_log('Has been deleted a Source : ' . $source->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
