<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Bed.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Bed
 * @description     : Manage bed.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Bed extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Bed_Model', 'bed', true);
    }


    /*****************Function floor**********************************
     * @type            : Function
     * @function name   : floor
     * @description     : Load "Floor List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function floor() {

        check_permission(VIEW);
        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('hospital/bed/floor/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->bed->get_floor_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['floors'] = $this->bed->get_floor_list($config['per_page'], $offset, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('floor') . ' ' . $this->lang->line('list') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bed/floor/index', $this->data);
    }

    /*****************Function add_floor**********************************
     * @type            : Function
     * @function name   : add_floor
     * @description     : Load "Add new Floor" user interface
     *                    and process to store "floors" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add_floor() {

        check_permission(ADD);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_floor_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $insert_id = $this->bed->insert('floors', $data);
                if ($insert_id) {
                    create_log('Has been created a Floor : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('hospital/bed/floor');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('hospital/bed/add_floor');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('floor') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bed/floor/add', $this->data);
    }

    /*****************Function edit_floor**********************************
     * @type            : Function
     * @function name   : edit_floor
     * @description     : Load "Edit new Floor" user interface
     *                    and process to store "floors" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function edit_floor($id = NULL) {

        check_permission(EDIT);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_floor_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $updated = $this->bed->update('floors', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a Floor : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('hospital/bed/floor');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('hospital/bed/edit_floor/' . $this->input->post('id'));
                }
            } else {
                $this->data['floor'] = $this->bed->get_single('floors', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['floor'] = $this->bed->get_single('floors', array('id' => $id));
                if (!$this->data['floor']) {
                    redirect('hospital/bed/floor');
                }
            }
        }

        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('floor') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bed/floor/edit', $this->data);
    }

    /*****************Function floor_name**********************************
     * @type            : Function
     * @function name   : floor_name
     * @description     : Unique check for "Floor Name" data/value
     *
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function floor_name() {
        if ($this->input->post('id') == '') {
            $floor = $this->bed->duplicate_check_floor_name($this->input->post('name'));
            if ($floor) {
                $this->form_validation->set_message('floor_name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('id') != '') {
            $floor = $this->bed->duplicate_check_floor_name($this->input->post('name'), $this->input->post('id'));
            if ($floor) {
                $this->form_validation->set_message('floor_name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /*****************Function delete_floor**********************************
     * @type            : Function
     * @function name   : delete_floor
     * @description     : delete "Floor" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete_floor($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('hospital/bed/floor');
        }

        $floor = $this->bed->get_single('floors', array('id' => $id));

        if ($this->bed->delete('floors', array('id' => $id))) {
            create_log('Has been deleted a Floor : ' . $floor->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }


    /*****************Function group**********************************
     * @type            : Function
     * @function name   : group
     * @description     : Load "Bed Group List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function group() {

        check_permission(VIEW);
        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('hospital/bed/floor/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->bed->get_bed_group_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['groups'] = $this->bed->get_bed_group_list($config['per_page'], $offset, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('bed') . ' ' . $this->lang->line('group') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bed/group/index', $this->data);
    }

    /*****************Function add_group**********************************
     * @type            : Function
     * @function name   : add_group
     * @description     : Load "Add new Bed Group" user interface
     *                    and process to store "bed_groups" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add_group() {

        check_permission(ADD);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('floor_id', $this->lang->line('floor'), 'trim|required');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_group_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['floor_id'] = $this->input->post('floor_id');
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $insert_id = $this->bed->insert('bed_groups', $data);
                if ($insert_id) {
                    create_log('Has been created a Bed Group : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('hospital/bed/group');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('hospital/bed/add_group');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['floors'] = $this->bed->get_list('floors', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('group') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bed/group/add', $this->data);
    }

    /*****************Function edit_group**********************************
     * @type            : Function
     * @function name   : edit_group
     * @description     : Load "Edit new Floor" user interface
     *                    and process to store "bed_groups" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function edit_group($id = NULL) {

        check_permission(EDIT);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('floor_id', $this->lang->line('floor'), 'trim|required');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_floor_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['floor_id'] = $this->input->post('floor_id');
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $updated = $this->bed->update('bed_groups', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a Bed Group : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('hospital/bed/group');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('hospital/bed/edit_group/' . $this->input->post('id'));
                }
            } else {
                $this->data['group'] = $this->bed->get_single('bed_groups', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['group'] = $this->bed->get_single('bed_groups', array('id' => $id));
                if (!$this->data['group']) {
                    redirect('hospital/bed/group');
                }
            }
        }
        $this->data['floors'] = $this->bed->get_list('floors', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('group') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bed/group/edit', $this->data);
    }

    /*****************Function group_name**********************************
     * @type            : Function
     * @function name   : group_name
     * @description     : Unique check for "Bed Group Name" data/value
     *
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function group_name() {
        if ($this->input->post('id') == '') {
            $group = $this->bed->duplicate_check_group_name($this->input->post('floor_id'), $this->input->post('name'));
            if ($group) {
                $this->form_validation->set_message('group_name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('id') != '') {
            $group = $this->bed->duplicate_check_group_name($this->input->post('floor_id'), $this->input->post('name'), $this->input->post('id'));
            if ($group) {
                $this->form_validation->set_message('group_name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /*****************Function delete_group**********************************
     * @type            : Function
     * @function name   : delete_group
     * @description     : delete "Bed Group" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete_group($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('hospital/bed/group');
        }

        $group = $this->bed->get_single('bed_groups', array('id' => $id));

        if ($this->bed->delete('bed_groups', array('id' => $id))) {
            create_log('Has been deleted a Bed Group : ' . $group->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    /*****************Function type**********************************
     * @type            : Function
     * @function name   : type
     * @description     : Load "Bed Type List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function type() {

        check_permission(VIEW);
        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('hospital/bed/floor/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->bed->get_bed_type_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['types'] = $this->bed->get_bed_type_list($config['per_page'], $offset, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('bed') . ' ' . $this->lang->line('type') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bed/type/index', $this->data);
    }

    /*****************Function add_type**********************************
     * @type            : Function
     * @function name   : add_type
     * @description     : Load "Add new Bed Type" user interface
     *                    and process to store "bed_types" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add_type() {

        check_permission(ADD);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_type_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $insert_id = $this->bed->insert('bed_types', $data);
                if ($insert_id) {
                    create_log('Has been created a Bed Type : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('hospital/bed/type');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('hospital/bed/add_type');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('type') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bed/type/add', $this->data);
    }

    /*****************Function edit_type**********************************
     * @type            : Function
     * @function name   : edit_type
     * @description     : Load "Edit new Bed Type" user interface
     *                    and process to store "bed_types" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function edit_type($id = NULL) {

        check_permission(EDIT);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_type_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $updated = $this->bed->update('bed_types', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a Bed Type : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('hospital/bed/type');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('hospital/bed/edit_type/' . $this->input->post('id'));
                }
            } else {
                $this->data['type'] = $this->bed->get_single('bed_types', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['type'] = $this->bed->get_single('bed_types', array('id' => $id));
                if (!$this->data['type']) {
                    redirect('hospital/bed/type');
                }
            }
        }

        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('type') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bed/type/edit', $this->data);
    }

    /*****************Function type_name**********************************
     * @type            : Function
     * @function name   : type_name
     * @description     : Unique check for "Bed Type Name" data/value
     *
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function type_name() {
        if ($this->input->post('id') == '') {
            $type = $this->bed->duplicate_check_type_name($this->input->post('name'));
            if ($type) {
                $this->form_validation->set_message('type_name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('id') != '') {
            $type = $this->bed->duplicate_check_type_name($this->input->post('name'), $this->input->post('id'));
            if ($type) {
                $this->form_validation->set_message('type_name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /*****************Function delete_type**********************************
     * @type            : Function
     * @function name   : delete_type
     * @description     : delete "Bed Type" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete_type($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('hospital/bed/type');
        }

        $type = $this->bed->get_single('bed_types', array('id' => $id));

        if ($this->bed->delete('bed_types', array('id' => $id))) {
            create_log('Has been deleted a Bed Type : ' . $type->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }



    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Bed List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);
        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('hospital/bed/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->bed->get_bed_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['beds'] = $this->bed->get_bed_list($config['per_page'], $offset, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('bed') . ' ' . $this->lang->line('list') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bed/index', $this->data);
    }

    /*****************Function status**********************************
     * @type            : Function
     * @function name   : status
     * @description     : Load "Bed Status List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function status() {

        check_permission(VIEW);
        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('hospital/bed/status/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->bed->get_bed_status_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['beds'] = $this->bed->get_bed_status_list($config['per_page'], $offset, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('bed') . ' ' . $this->lang->line('status') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bed/status', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new Bed" user interface
     *                    and process to store "beds" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add() {

        check_permission(ADD);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('type_id', $this->lang->line('type'), 'trim|required');
            $this->form_validation->set_rules('group_id', $this->lang->line('group'), 'trim|required');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');
            $this->form_validation->set_rules('price', $this->lang->line('price'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['type_id'] = $this->input->post('type_id');
                $data['group_id'] = $this->input->post('group_id');
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['price'] = $this->input->post('price');
                $data['commission'] = $this->input->post('commission');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $insert_id = $this->bed->insert('beds', $data);
                if ($insert_id) {
                    create_log('Has been created a Bed : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('hospital/bed');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('hospital/bed/add');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['types'] = $this->bed->get_list('bed_types', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['groups'] = $this->bed->get_bed_group_list(NUll, NULL, NUll, NULL);
        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('bed') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bed/add', $this->data);
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load "Edit new Bed" user interface
     *                    and process to store "beds" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function edit($id = NULL) {

        check_permission(EDIT);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('type_id', $this->lang->line('type'), 'trim|required');
            $this->form_validation->set_rules('group_id', $this->lang->line('group'), 'trim|required');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');
            $this->form_validation->set_rules('price', $this->lang->line('price'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['type_id'] = $this->input->post('type_id');
                $data['group_id'] = $this->input->post('group_id');
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['price'] = $this->input->post('price');
                $data['commission'] = $this->input->post('commission');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $updated = $this->bed->update('beds', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a Bed : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('hospital/bed');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('hospital/bed/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data['bed'] = $this->bed->get_single('beds', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['bed'] = $this->bed->get_single('beds', array('id' => $id));
                if (!$this->data['bed']) {
                    redirect('hospital/bed');
                }
            }
        }
        $this->data['types'] = $this->bed->get_list('bed_types', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['groups'] = $this->bed->get_bed_group_list(NUll, NULL, NUll, NULL);
        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('bed') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('bed/edit', $this->data);
    }

    /*****************Function name**********************************
     * @type            : Function
     * @function name   : name
     * @description     : Unique check for "Bed Name" data/value
     *
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function name() {
        if ($this->input->post('id') == '') {
            $bed = $this->bed->duplicate_check($this->input->post('type_id'), $this->input->post('group_id'), $this->input->post('name'));
            if ($bed) {
                $this->form_validation->set_message('name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('id') != '') {
            $bed = $this->bed->duplicate_check($this->input->post('type_id'), $this->input->post('group_id'), $this->input->post('name'), $this->input->post('id'));
            if ($bed) {
                $this->form_validation->set_message('name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Bed" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('hospital/bed');
        }

        $bed = $this->bed->get_single('beds', array('id' => $id));

        if ($this->bed->delete('beds', array('id' => $id))) {
            create_log('Has been deleted a Bed : ' . $bed->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
