<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('call_log'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('call_log'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('frontoffice/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'frontoffice', 'calllog')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-phone font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('call_log'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'frontoffice', 'calllog')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('frontoffice/calllog'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('call_log'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('frontoffice/calllog/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="name"><?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="phone"><?php echo $this->lang->line('phone'); ?></label>
                            <input type="number" class="form-control" name="phone" id="phone" value="<?php echo isset($phone) ?  $phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="call_date"><?php echo $this->lang->line('call_date'); ?></label>
                            <input type="text" class="form-control" name="call_date" id="call_date" value="<?php echo isset($call_date) ?  $call_date : ''; ?>" placeholder="<?php echo $this->lang->line('call_date'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="next_follow_up"><?php echo $this->lang->line('follow_up'); ?></label>
                            <input type="text" class="form-control" name="next_follow_up" id="next_follow_up" value="<?php echo isset($next_follow_up) ?  $next_follow_up : ''; ?>" placeholder="<?php echo $this->lang->line('follow_up'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="call_duration"><?php echo $this->lang->line('call_duration'); ?></label>
                            <input type="text" class="form-control" name="call_duration" id="call_duration" value="<?php echo isset($call_duration) ?  $call_duration : ''; ?>" placeholder="<?php echo $this->lang->line('call_duration'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="call_type"><?php echo $this->lang->line('call_type'); ?></label>
                            <div class="row">
                                <div class="col-md-6 mt-5">
                                    <div class="custom-control custom-radio radio-primary">
                                        <input type="radio" id="incoming" name="call_type" value="1" class="custom-control-input" checked>
                                        <label class="custom-control-label" for="incoming"><?php echo $this->lang->line('incoming'); ?></label>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-5">
                                    <div class="custom-control custom-radio radio-danger">
                                        <input type="radio" id="outgoing" name="call_type" value="0" class="custom-control-input">
                                        <label class="custom-control-label" for="outgoing"><?php echo $this->lang->line('outgoing'); ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('note'); ?></span>
                                </div>
                                <textarea class="form-control" name="note" id="note" aria-label="<?php echo $this->lang->line('note'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('frontoffice/calllog'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>


<script>
    $("#call_date, #next_follow_up").daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD'
        }
    });
</script>