<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Visitor_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_visitor_list($limit, $offset, $search, $count) {
        $this->db->select('V.*, VP.name as visitor_purpose, VP.bn_name as visitor_purpose_bn');
        $this->db->from('visitors AS V');
        $this->db->join('visitor_purposes AS VP', 'VP.id = V.purpose_id', 'left');
        if ($search) {
            $this->db->like('V.phone', $search);
            $this->db->or_like('V.name', $search);
            $this->db->or_like('V.email', $search);
            $this->db->or_like('V.no_of_people', $search);
            $this->db->or_like('V.date', $search);
            $this->db->or_like('V.note', $search);
            $this->db->or_like('VP.name', $search);
        }
        $this->db->order_by('V.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
}
