<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Dispatch_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_dispatch_list($limit, $offset, $search, $count) {
        $this->db->select('D.*');
        $this->db->from('dispatchs AS D');
        if ($search) {
            $this->db->like('D.to_title', $search);
            $this->db->or_like('D.reference', $search);
            $this->db->or_like('D.from_title', $search);
            $this->db->or_like('D.address', $search);
            $this->db->or_like('D.date', $search);
            $this->db->or_like('D.note', $search);
        }
        $this->db->order_by('D.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
}
