<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Frontend_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_page_list($limit, $offset, $search, $count) {
        $this->db->select('P.*');
        $this->db->from('pages AS P');
        if ($search) {
            $this->db->like('P.title', $search, 'both');
            $this->db->or_like('P.description', $search, 'both');
        }
        $this->db->order_by('P.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
}
