<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Menu.php**********************************
 * @product name    : CMS Management System
 * @type            : Class
 * @class name      : Menu
 * @description     : Manage frontend menu of the hospital.
 * @author          : South Bangla IT Zone Team
 * @url             : http://cms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Menu extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Menu_Model', 'menu', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Menu List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index($menu_id = null, $id = null) {

        if (isset($menu_id) && $menu_id > 0) {
            if ($_POST) {
                $this->load->library('form_validation');
                $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
                $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required');

                if ($this->form_validation->run() === TRUE) {
                    $data['menu_id'] = $this->input->post('menu_id');
                    $data['name'] = $this->input->post('name');
                    $data['bn_name'] = $this->input->post('bn_name');
                    $data['external_url'] = $this->input->post('external_url') ?? 0;
                    $data['open_new_tab'] = $this->input->post('open_new_tab') ? $this->input->post('open_new_tab') : 0;
                    $data['ext_url_link'] = $this->input->post('ext_url_link') ? $this->input->post('ext_url_link') : null;
                    $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                    $data['page_id'] = $this->input->post('page_id');


                    if ($this->input->post('id')) {

                        $data['modified_at'] = date('Y-m-d H:i:s');
                        $data['modified_by'] = logged_in_user_id();

                        $updated_id = $this->menu->update('menu_items', $data, array('id' => $this->input->post('id')));
                        if ($updated_id) {
                            create_log('Has been updated a Menu : ' . $data['name']);
                            success($this->lang->line('update_success'));
                            redirect('frontend/menu/index/' . $menu_id);
                        } else {
                            error($this->lang->line('update_failed'));
                            redirect('frontend/menu');
                        }
                    } else {
                        $data['created_at'] = date('Y-m-d H:i:s');
                        $data['created_by'] = logged_in_user_id();

                        $insert_id = $this->menu->insert('menu_items', $data);
                        if ($insert_id) {
                            create_log('Has been created a Menu : ' . $data['name']);
                            success($this->lang->line('insert_success'));
                            redirect('frontend/menu/index/' . $menu_id);
                        } else {
                            error($this->lang->line('insert_failed'));
                            redirect('frontend/menu');
                        }
                    }
                } else {
                    $this->data = $_POST;
                }
            }

            $this->data['menu_item'] = $this->menu->get_single('menu_items', array('id' => $id));
            $this->data['menu_items'] = $this->menu->get_list('menu_items', array('menu_id' => $menu_id), '', '', '', 'sort_by', 'ASC');
            $this->data['pages'] = $this->menu->get_list('pages', array('status' => 1), '', '', '', 'id', 'ASC');
            $this->data['list'] = TRUE;
            $this->layout->title($this->lang->line('manage_menu') . ' | ' . $this->global_setting->brand_title);
            $this->layout->view('frontend/menu/menu-item', $this->data);
        } else {
            check_permission(VIEW);

            $this->data['menus'] = $this->menu->get_list('menus', array(), '', '', '', 'sort_by', 'ASC');
            $this->data['list'] = TRUE;
            $this->layout->title($this->lang->line('manage_menu') . ' | ' . $this->global_setting->brand_title);
            $this->layout->view('frontend/menu/index', $this->data);
        }
    }

    public function save_menu() {
        $data = json_decode($_POST['data']);
        function parseJsonArray($jsonArray, $parentID = 0) {
            $return = array();
            foreach ($jsonArray as $subArray) {
                $returnSubSubArray = array();
                if (isset($subArray->children)) {
                    $returnSubSubArray = parseJsonArray($subArray->children, $subArray->id);
                }
                $return[] = array('id' => $subArray->id, 'parentID' => $parentID);
                $return = array_merge($return, $returnSubSubArray);
            }
            return $return;
        }
        $readbleArray = parseJsonArray($data);
        $i = 0;
        foreach ($readbleArray as $row) {
            $i++;
            $this->menu->update('menu_items', array('parent_id' => $row['parentID'], 'sort_by' => $i), array('id' => $row['id']));
        }
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add Menu" user interface
     *                    and process to store "menus" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function add() {

        check_permission(ADD);

        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('location', $this->lang->line('location'), 'trim|required|callback_location');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['location'] = $this->input->post('location');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ?? 0;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();
                $insert_id = $this->menu->insert('menus', $data);
                if ($insert_id) {
                    create_log('Has been created a menu : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('frontend/menu');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('frontend/menu/add');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('menu') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('frontend/menu/add', $this->data);
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Frontend Menu" user interface
     *                    with populate "Frontend Menu" value
     *                    and process to update "menus" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function edit($id = null) {

        check_permission(EDIT);

        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('location', $this->lang->line('location'), 'trim|required|callback_location');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['location'] = $this->input->post('location');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ?? 0;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $updated = $this->menu->update('menus', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been update a menu : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('frontend/menu');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('frontend/menu/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data['menu'] = $this->menu->get_single('menus', array('id' => $id));
            }
        } else {
            if ($id) {
                $this->data['menu'] = $this->menu->get_single('menus', array('id' => $id));
                if (!$this->data['menu']) {
                    redirect('frontend/menu');
                }
            }
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('menu') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('frontend/menu/edit', $this->data);
    }

    /*     * ***************Function location**********************************
     * @type            : Function
     * @function name   : location
     * @description     : Unique check for "location" data/value
     *
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */

    public function location() {
        if ($this->input->post('id') == '') {
            $location = $this->menu->duplicate_check($this->input->post('location'));
            if ($location) {
                $this->form_validation->set_message('location', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('id') != '') {
            $location = $this->menu->duplicate_check($this->input->post('location'), $this->input->post('id'));
            if ($location) {
                $this->form_validation->set_message('location', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Pages" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('frontend/menu');
        }

        $menu = $this->menu->get_single('menus', array('id' => $id));
        if ($this->menu->delete('menus', array('id' => $id))) {
            $this->menu->delete('menu_items', array('menu_id' => $menu->id));
            create_log('Has been deleted a menu : ' . $menu->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    /*****************Function delete_menu_item**********************************
     * @type            : Function
     * @function name   : delete_menu_item
     * @description     : delete "Delete Menu Item" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete_menu_item($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('frontend/menu');
        }

        $item = $this->menu->get_single('menu_items', array('id' => $id));
        if ($this->menu->delete('menu_items', array('id' => $id))) {
            create_log('Has been deleted a menu item : ' . $item->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
