<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Schedule_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_schedule_list($limit, $offset, $search, $count) {
        $this->db->select('S.*, E.name as doctor');
        $this->db->from('doctor_schedules AS S');
        $this->db->join('employees AS E', 'E.user_id = S.doctor_id', 'left');
        if ($search) {
            $this->db->like('S.day', $search, 'both');
            $this->db->or_like('E.name', $search, 'both');
            $this->db->or_like('S.serial_visibility', $search);
            $this->db->or_like('S.note', $search, 'both');
        }
        $this->db->order_by('S.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_doctor_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        return $this->db->get()->result();
    }

    function duplicate_check($doctor_id, $day, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('doctor_id', $doctor_id);
        $this->db->where('day', $day);
        return $this->db->get('doctor_schedules')->num_rows();
    }
}
