<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Charge_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_charge_list($limit, $offset, $search, $count) {
        $this->db->select('DC.*, E.name as doctor');
        $this->db->from('doctor_charges AS DC');
        $this->db->join('employees AS E', 'E.user_id = DC.doctor_id', 'left');
        if ($search) {
            $this->db->like('DC.first_fee', $search);
            $this->db->or_like('E.name', $search, 'both');
            $this->db->or_like('DC.note', $search, 'both');
        }
        $this->db->order_by('DC.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_doctor_list() {
        $this->db->select('E.*, C.doctor_id');
        $this->db->from('employees AS E');
        $this->db->join('doctor_charges AS C', 'C.doctor_id = E.user_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        return $this->db->get()->result();
    }

    function duplicate_check($doctor_id, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('doctor_id', $doctor_id);
        return $this->db->get('doctor_charges')->num_rows();
    }
}
