<!DOCTYPE html>
<html>

<head>
    <title>Report Print</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            margin-top: 110px;
        }


        .table {
            width: 100%;
            border: 1px solid #000;
        }

        .table_patient thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            padding: 10px;
            border-radius: 10px;
            font-size: 13px;
        }

        .table_patient tbody td {
            padding: 0px 10px;
            vertical-align: middle;
            border: 0;
            font-size: 15px;
        }

        .report {
            margin-top: 30px;
            min-height: 645px;
            font-size: 12px;
        }

        .report table td {
            padding-left: 3px;
            vertical-align: middle;
        }

        .footer p {
            font-size: 10px;
        }

        .footer strong {
            font-size: 12px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table table_patient">
                <tbody>
                    <tr>
                        <td width="14%" style="border-right:none;"><b>ID No:</b></td>
                        <td width="1%" style="border-left:none; border-right:none;"><b>:</b></td>
                        <td style="border-left:none; border-right:none; text-transform:uppercase"><b><?php echo $template->patient_unique_id; ?></b></td>
                        <td style="border-left:none; border-right:none;"> </td>
                        <td width="35%" style="border-left:none; border-right:none;"><b>Print Date:</b> <?php echo date('d/m/Y h:i A'); ?></td>
                        
                    </tr>
                    <tr>
                        <td width="14%" style="border-right:none;"><b>Name</b></td>
                        <td width="1%" style="border-left:none; border-right:none;">:</td>
                        <td style="border-left:none; border-right:none;"><b><?php echo $template->patient; ?></b></td>
                        <td style="border-right:none;"><b>Gender:</b> <?php echo $this->lang->line($template->gender); ?></td>
                        <td style="border-left:none; border-right:none;"><b>Age:</b> <?php echo $template->dob != NULL ? get_age($template->dob) : ''; ?></td>
                        
                    </tr>
                    
                    <tr>
                        <td width="14%" style="border-right:none;"><b>Refd. By</b></td>
                        <td width="1%" style="border-left:none; border-right:none;">:</td>
                        <td colspan="3" style="border-left:none;">
                            
                                <?php if ($template->self) {
                                    echo 'Self';
                                } elseif ($template->ref_dr_id > 0) {
                                    echo $template->doctor . ', ' . $template->specialist;
                                } else {
                                    echo $template->ref_dr_name;
                                }
                                ?>
                            
                        </td>
                    </tr>
                    <tr>
                        <td width="14%" style="border-right:none;"><b>Specimen:</b></td>
                        <td width="1%" style="border-left:none; border-right:none;">:</td>
                        <td colspan="2" style="border-left:none; text-transform: uppercase;"><?php echo $template->specimen; ?></td>
                    </tr>
                    <?php if ($template->remark) { ?>
                        <tr>
                            <td width="14%" style="border-right:none;"><b>Remark:</b></td>
                            <td width="1%" style="border-left:none; border-right:none;"><b>:</b></td>
                            <td colspan="2" style="border-left:none;"><?php echo $template->remark; ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>

            <div class="border"></div>

            <!-- Repoart Body Start-->
            <div class="report">
                <?php echo $template->template ? $template->template : ''; ?>
            </div>
            <!-- Repoart Body End-->

            <!-- Footer -->

            <div class="footer" style="width: 100%;">
                <div style="width: 30%; float: left;">
                    <?php echo isset($signature_1->name) && !empty($signature_1->name) ? $signature_1->name : '&nbsp;'; ?>
                </div>
                <div style="width: 30%; margin: 0 5%; float: left;">
                    <?php echo isset($signature_2->name) && !empty($signature_2->name) ? $signature_2->name : '&nbsp;'; ?>
                </div>
                <div style="width: 30%; float: left;">
                    <?php echo isset($signature_3->name) && !empty($signature_3->name) ? $signature_3->name : '&nbsp;'; ?>
                </div>
            </div>
        </div>
    </div>
</body>

</html>