<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('laboratorist'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('laboratorist'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'diagnostic', 'laboratorist')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user font-30 mr-10"></i>
                            <?php echo $this->lang->line('laboratorist'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php echo form_open_multipart(site_url('diagnostic/laboratorist'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>" required>
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>

                    <?php if (has_permission(ADD, 'diagnostic', 'laboratorist')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('diagnostic/laboratorist/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('laboratorist'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <div class="card-body">
                    <?php if (isset($laboratorists) && !empty($laboratorists)) { ?>
                        <?php foreach ($laboratorists as $obj) {
                            $departments = $this->laboratorist->get_list('diagnostic_laboratorists', array('department_id' =>  $obj->department_id));
                        ?>
                            <h5 class="hk-sec-title shadow-xl pa-10 bg-light rounded mb-30 font-weight-bold text-uppercase text-center"><?php echo $obj->department; ?></h5>
                            <div class="row">
                                <?php if (isset($departments) && !empty($departments)) { ?>
                                    <?php foreach ($departments as $obj) { ?>
                                        <div class="col-md-6">
                                            <blockquote class="blockquote" style="min-height: 240px;">
                                                <div class="row">
                                                    <div class="col-md-9">
                                                        <p><?php echo $obj->name; ?></p>
                                                        <footer class="blockquote-footer">
                                                            <?php echo $obj->status ? '<span class="badge badge-success">' . $this->lang->line('active') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('in_active') . '</span>'; ?>
                                                        </footer>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="float-right">
                                                            <?php if (has_permission(EDIT, 'diagnostic', 'laboratorist')) { ?>
                                                                <a class="btn btn-xs btn-success mr-5" href="<?php echo site_url('diagnostic/laboratorist/edit/' . $obj->id); ?>"><i class="fa fa-pencil-square-o"></i></a>
                                                            <?php } ?>
                                                            <?php if (has_permission(DELETE, 'diagnostic', 'laboratorist')) { ?>
                                                                <a class="btn btn-xs btn-danger round" href="<?php echo site_url('diagnostic/laboratorist/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i></a>
                                                            <?php } ?>
                                                            <span><?php echo $this->lang->line('sort_by'); ?>: <?php echo $obj->sort_by; ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </blockquote>
                                        </div>
                                    <?php } ?>
                                <?php } else { ?>
                                    <div class="col-md-12">
                                        <p><?php echo $this->lang->line('no_data_found'); ?></p>
                                    </div>
                                <?php } ?>
                            </div>
                        <?php } ?>
                    <?php } else { ?>
                        <div class="col-md-12">
                            <p><?php echo $this->lang->line('no_data_found'); ?></p>
                        </div>
                    <?php } ?>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->