<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Ultrasonography.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Ultrasonography
 * @description     : Manage ultrasonography.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Ultrasonography extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Ultrasonography_Model', 'ultrasonography', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Ultrasonography List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('diagnostic/ultrasonography/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->ultrasonography->get_ultrasonography_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['ultrasonographys'] = $this->ultrasonography->get_ultrasonography_list($config['per_page'], $offset, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));

        $this->data['search'] = $search;
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('ultrasonography') . ' ' . $this->lang->line('template') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('ultrasonography/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new Ultrasonography" user interface
     *                    and process to store "ultrasonographys" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add() {

        check_permission(ADD);
        if ($_POST) {
            $this->_prepare_ultrasonography_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_ultrasonography_data();
                $insert_id = $this->ultrasonography->insert('ultrasonography_templates', $data);
                if ($insert_id) {
                    create_log('Has been created a Ultrasonography Template : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('diagnostic/ultrasonography');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('diagnostic/ultrasonography/add');
                }
            } else {
                $this->data = $_POST;
            }
        }
        $this->data['doctors'] = $this->ultrasonography->get_doctor_list();
        $this->data['departments'] = $this->ultrasonography->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('ultrasonography') . ' ' . $this->lang->line('template') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('ultrasonography/add', $this->data);
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Ultrasonography" user interface
     *                    with populate "Ultrasonography" value
     *                    and process to update "ultrasonographys" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function edit($id = null) {
        check_permission(EDIT);

        if ($_POST) {
            $this->_prepare_ultrasonography_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_ultrasonography_data();
                $updated = $this->ultrasonography->update('ultrasonography_templates', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a Ultrasonography Template : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('diagnostic/ultrasonography');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('diagnostic/ultrasonography/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data['ultrasonography'] = $this->ultrasonography->get_single('ultrasonography_templates', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['ultrasonography'] = $this->ultrasonography->get_single('ultrasonography_templates', array('id' => $id));
                if (!$this->data['ultrasonography']) {
                    redirect('diagnostic/ultrasonography');
                }
            }
        }
        $this->data['doctors'] = $this->ultrasonography->get_doctor_list();
        $this->data['departments'] = $this->ultrasonography->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['groups'] = $this->ultrasonography->get_list('diagnostic_groups', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['tests'] = $this->ultrasonography->get_list('diagnostic_tests', array('status' => 1, 'department_id' => $this->data['ultrasonography']->department_id), '', '', '', 'sort_by', 'ASC');
        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('ultrasonography') . ' ' . $this->lang->line('template') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('ultrasonography/edit', $this->data);
    }

    /*     * ***************Function get_single_ultrasonography**********************************
     * @type            : Function
     * @function name   : get_single_ultrasonography
     * @description     : "Load single ultrasonography information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_ultrasonography() {
        $id = $this->input->post('id');
        $this->data['ultrasonography'] = $this->ultrasonography->get_single_ultrasonography($id);
        echo $this->load->view('diagnostic/ultrasonography/view', $this->data);
    }

    /*****************Function _prepare_ultrasonography_validation**********************************
     * @type            : Function
     * @function name   : _prepare_ultrasonography_validation
     * @description     : Process "Ultrasonography" user input data validation
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    private function _prepare_ultrasonography_validation() {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
        $this->form_validation->set_rules('doctor_id', $this->lang->line('doctor') . ' ' . $this->lang->line('name'), 'trim|required');
        $this->form_validation->set_rules('department_id', $this->lang->line('department') . ' ' . $this->lang->line('name'), 'trim|required');
        $this->form_validation->set_rules('test_id', $this->lang->line('test') . ' ' . $this->lang->line('name'), 'trim|required');
        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required');
        $this->form_validation->set_rules('template', $this->lang->line('template'), 'trim|required');
    }

    /*****************Function _get_posted_ultrasonography_data**********************************
     * @type            : Function
     * @function name   : _get_posted_ultrasonography_data
     * @description     : Prepare "Ultrasonography" user input data to save into database
     *
     * @param           : null
     * @return          : $data array(); value
     * ********************************************************** */
    private function _get_posted_ultrasonography_data() {

        $items = array();
        $items[] = 'doctor_id';
        $items[] = 'department_id';
        $items[] = 'group_id';
        $items[] = 'test_id';
        $items[] = 'name';
        $items[] = 'template';
        $items[] = 'status';

        $data = elements($items, $_POST);

        if ($this->input->post('id')) {
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();
        } else {
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();
        }
        return $data;
    }

    /*     * ***************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Ultrasonography" data from database
     *                     and unlink ultrasonography photo and Resume from server
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */

    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('diagnostic/ultrasonography');
        }

        $ultrasonography = $this->ultrasonography->get_single('ultrasonography_templates', array('id' => $id));
        if (!empty($ultrasonography)) {
            // delete ultrasonography data
            $this->ultrasonography->delete('ultrasonography_templates', array('id' => $id));
            create_log('Has been deleted a Ultrasonography Template : ' . $ultrasonography->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect('diagnostic/ultrasonography');
    }
}
