<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Event_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_event_list($limit, $offset, $keyword, $form_date, $to_date, $role_id, $created_by, $count) {
        $this->db->select('E.*, R.name as role');
        $this->db->from('events AS E');
        $this->db->join('roles AS R', 'R.id = E.role_id', 'left');
        if ($keyword) {
            $this->db->like('E.title', $keyword, 'both');
            $this->db->or_like('E.description', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(E.created_at) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($role_id) {
            $this->db->where('E.role_id', $role_id);
        }
        if ($created_by) {
            $this->db->where('E.created_by', $created_by);
        }
        $this->db->order_by('E.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_event($id) {
        $this->db->select('E.*, R.name as role, C.name as created_by, M.name as modified_by');
        $this->db->from('events AS E');
        $this->db->join('roles AS R', 'R.id = E.role_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = E.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = E.modified_by', 'left');
        $this->db->where('E.id', $id);
        return $this->db->get()->row();
    }
}
