<!DOCTYPE html>
<html>

<head>
    <title>Print Bill</title>

    <style>
        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 13px;
        }

        @media print {
            @page {
                size: landscape
            }
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .header {
            width: 100%;
            display: inline-block;
        }

        .header img {
            width: 80px;
        }

        .header h1 {
            margin: 0;
            padding: 0;
            text-transform: uppercase;
            font-size: 30px;
        }

        .header p {
            margin: 0;
            padding: 0;
        }

        .header .title {
            margin-top: 10px;
            margin-bottom: 10px;
            text-align: center;
        }

        .header .title span {
            background-color: #000;
            color: #fff;
            border: 1px solid #000;
            border-radius: 5px;
            font-family: monospace;
            font-size: 16px;
            font-weight: bold;
            padding: 5px 10px;
            text-transform: uppercase;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info {
            margin-bottom: 20px;
        }

        .info tbody td {
            color: #000;
            vertical-align: middle;
            font-weight: bold;
            padding: 3px 0;
        }

        .details thead th {
            color: #000;
            padding: 1px;
            vertical-align: middle;
            border: 1px solid #000;
            width: max-content;
            font-size: 10px;
        }

        .details tbody td {
            color: #000;
            padding: 1px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 10px;
        }

        .details tfoot td {
            color: #000;
            padding: 1px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 10px;
        }


        .summary {
            width: 50%;
            margin: 20px auto;
            float: right;
        }

        .summary tbody td {
            color: #000;
            padding: 3px;
            vertical-align: middle;
            border: 1px solid #000;
            font-weight: bold;
            text-align: left;
            font-size: 10px;
        }
        .sign {
            width: 100%;
            margin-top: 30px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="header">
            <table class="table">
                <tbody>
                    <tr>
                        <td rowspan="2" width="20%" align="right">
                            <?php if ($this->global_setting->brand_logo) { ?>
                                <img src="<?php echo UPLOAD_PATH; ?>logo/<?php echo $this->global_setting->brand_logo; ?>" alt="logo">
                            <?php } else { ?>
                                <img src="<?php echo IMG_URL; ?>logo.png" alt="logo">
                            <?php } ?>
                        </td>
                        <td width="60%" align="center">
                            <h1><?php echo $this->global_setting->brand_title; ?></h1>
                            <p><?php echo $this->global_setting->address; ?></p>
                            <p><?php echo $this->global_setting->phone; ?></p>
                        </td>
                        <td width="20%"></td>
                    </tr>
                    <tr>
                        <td>
                            <div class="title" align="center">
                                <span>Investigation Payment Voucher</span>
                            </div>
                        </td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        </div>
        <!-- Header End -->
        <div class="body">
            <table class="table info">
                <tbody>
                    <tr>
                        <td>
                            Payment Invoice ID: <?php echo $reference->custom_invoice_id; ?>
                        </td>
                        <td colspan="2" align="right" style="font-weight: normal;">
                            Print Time: <?php echo date('M d, Y h:i A'); ?>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            ID: <?php echo $reference->reference_id; ?>
                        </td>
                        <td>
                            <?php
                            if ($reference->commission_type == 'mbbs') {
                                echo 'Doctor:';
                            } elseif ($reference->commission_type == 'vd') {
                                echo 'SD Name:';
                            } elseif ($reference->commission_type == 'emp') {
                                echo 'Employee Name:';
                            } else {
                                echo 'Corporate:';
                            }
                            ?>
                            <?php echo $reference->reference; ?>
                        </td>
                        <td align="right">
                            Payment Date: <?php echo date('M d, Y h:i A', strtotime($reference->date)); ?>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            Address: <?php echo $reference->address; ?>
                        </td>
                        <td align="right">
                            Prepared By: <?php echo $reference->created_by; ?>
                        </td>
                    </tr>
                </tbody>
            </table>

            <!-- Datails -->
            <table class="table details">
                <thead>
                    <tr>
                        <th>Invoice No</th>
                        <th>Bill Date</th>
                        <th>Patient Name</th>
                        <th>Patient ID</th>
                        <th>Total</th>
                        <th>Discount</th>
                        <?php foreach ($departments as $dept) { ?>
                            <th><?php echo $dept->name; ?></th>
                        <?php } ?>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $invoice_total_bill = 0;
                    $total_discount = 0;
                    foreach ($invoices as $inv) {
                        $invoice_total_bill += $inv->total_bill;
                        $total_discount += $inv->discount;
                    ?>
                        <tr>
                            <td><?php echo $inv->bill_invoice; ?></td>
                            <td><?php echo date('M d, Y h:ia', strtotime($inv->bill_date)); ?></td>
                            <td><?php echo $inv->patient; ?></td>
                            <td><?php echo $inv->patient_unique_id; ?></td>
                            <td><?php echo number_format($inv->total_bill, 2); ?></td>
                            <td><?php echo number_format($inv->discount, 2); ?></td>
                            <?php foreach ($departments as $dept) {
                                $test_amount = $this->payment->get_investigation_by_department_bill($inv->invoice_id, $dept->id); ?>
                                <td><?php echo number_format(($test_amount->total_rate ?? 0), 2); ?></td>
                            <?php } ?>
                        </tr>
                    <?php } ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="3" align="right"><strong>Total:</strong></td>
                        <td><?php echo number_format($invoice_total_bill, 2); ?></td>
                        <td><?php echo number_format($total_discount, 2); ?></td>
                        <?php foreach ($departments as $dept) {
                            $investigation_total = $this->payment->get_investigation_total_bill($dept->id, $reference->id);
                        ?>
                            <td><?php echo number_format(($investigation_total->total_rate ?? 0), 2); ?></td>
                        <?php } ?>
                    </tr>
                    <tr>
                        <td colspan="3" align="right"><strong>Commission:</strong></td>
                        <td><?php echo number_format($reference->total_commission_amount, 2); ?></td>
                        <td><?php echo number_format($total_discount, 2); ?></td>
                        <?php foreach ($departments as $dept) {
                            $investigation = $this->payment->get_investigation_total_bill($dept->id, $reference->id);
                        ?>
                            <td>
                                <?php
                                if ($reference->commission_type == 'mbbs') {
                                    echo number_format(($investigation->total_rate ?? 0) - ($investigation->total_mbbs ?? 0), 2);
                                } elseif ($reference->commission_type == 'vd') {
                                    echo number_format(($investigation->total_rate ?? 0) - ($investigation->total_vd ?? 0), 2);
                                } elseif ($reference->commission_type == 'emp') {
                                    echo number_format(($investigation->total_rate ?? 0) - ($investigation->total_emp ?? 0), 2);
                                } else {
                                    echo number_format(($investigation->total_rate ?? 0) - ($investigation->total_corporate ?? 0), 2);
                                }
                                ?>
                            </td>
                        <?php } ?>
                    </tr>
                </tfoot>
            </table>
            <!-- Summary -->
            <table class="table summary">
                <tbody>
                    <tr>
                        <td>Commission</td>
                        <td><?php echo number_format($reference->total_commission_amount, 2); ?></td>
                    </tr>
                    <tr>
                        <td>Discount</td>
                        <td><?php echo number_format($total_discount, 2); ?></td>
                    </tr>
                    <tr>
                        <td>Paid</td>
                        <td><?php echo number_format($reference->total_payable_commission, 2); ?></td>
                    </tr>
                </tbody>
            </table>
            <table class="sign">
                <tr>
                    <td width="30%">Signature</td>
                    <td width="70%">Mobile:</td>
                </tr>
            </table>
        </div>
    </div>
</body>

</html>