<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('accounting'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_payment'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
            <div class="card text-white bg-primary">
                <div class="card-header font-weight-bold font-22">
                    <i class="fa fa-stethoscope"></i>
                    <?php echo $this->lang->line('opd'); ?>
                </div>
                <div class="card-body text-center" style="min-height: 100px;">
                    <a href="<?php echo site_url('accounting/payment/opd'); ?>" class="btn btn-success">
                        <?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('payment'); ?>
                    </a>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
            <div class="card text-white bg-sky">
                <div class="card-header font-weight-bold font-22">
                    <i class="fa fa-h-square"></i>
                    <?php echo $this->lang->line('investigations'); ?>
                </div>
                <div class="card-body text-center" style="min-height: 100px;">
                    <a href="<?php echo site_url('accounting/payment/investigation'); ?>" class="btn btn-success">
                        <?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('payment'); ?>
                    </a>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
            <div class="card text-white bg-teal">
                <div class="card-header font-weight-bold font-22">
                    <i class="fa fa-user-md"></i>
                    <?php echo $this->lang->line('surgeon'); ?>
                </div>
                <div class="card-body text-center" style="min-height: 100px;">
                    <a href="<?php echo site_url('accounting/payment/surgeon'); ?>" class="btn btn-success">
                        <?php echo $this->lang->line('surgeon'); ?> <?php echo $this->lang->line('payment'); ?>
                    </a>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
            <div class="card text-white bg-gold">
                <div class="card-header font-weight-bold font-22">
                    <i class="fa fa-user-md"></i>
                    <?php echo $this->lang->line('anesthesia'); ?>
                </div>
                <div class="card-body text-center" style="min-height: 100px;">
                    <a href="<?php echo site_url('accounting/payment/anesthesia'); ?>" class="btn btn-success">
                        <?php echo $this->lang->line('anesthesia'); ?> <?php echo $this->lang->line('payment'); ?>
                    </a>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
            <div class="card text-white bg-blue">
                <div class="card-header font-weight-bold font-22">
                    <i class="fa fa-user"></i>
                    <?php echo $this->lang->line('assistant'); ?>
                </div>
                <div class="card-body text-center" style="min-height: 100px;">
                    <a href="<?php echo site_url('accounting/payment/assistant'); ?>" class="btn btn-success">
                        <?php echo $this->lang->line('assistant'); ?> <?php echo $this->lang->line('payment'); ?>
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
            <div class="card text-white bg-yellow">
                <div class="card-header font-weight-bold font-22">
                    <i class="fa fa-user-md"></i>
                    <?php echo $this->lang->line('consultant'); ?>
                </div>
                <div class="card-body text-center" style="min-height: 100px;">
                    <a href="<?php echo site_url('accounting/payment/consultant'); ?>" class="btn btn-success">
                        <?php echo $this->lang->line('consultant'); ?> <?php echo $this->lang->line('payment'); ?>
                    </a>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
            <div class="card text-white bg-indigo">
                <div class="card-header font-weight-bold font-22">
                    <i class="fa fa-bed"></i>
                    <?php echo $this->lang->line('ipd'); ?>
                </div>
                <div class="card-body text-center" style="min-height: 100px;">
                    <a href="<?php echo site_url('accounting/payment/ipd'); ?>" class="btn btn-success">
                        <?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('payment'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->