<!DOCTYPE html>
<html>

<head>
    <title>Print Bill</title>

    <style>
        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 13px;
        }

        @media print {
            @page {
                size: landscape
            }
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .header {
            width: 100%;
            display: inline-block;
        }

        .header img {
            width: 80px;
        }

        .header h1 {
            margin: 0;
            padding: 0;
            text-transform: uppercase;
            font-size: 30px;
        }

        .header p {
            margin: 0;
            padding: 0;
        }

        .header .title {
            margin-top: 10px;
            margin-bottom: 10px;
            text-align: center;
        }

        .header .title span {
            background-color: #000;
            color: #fff;
            border: 1px solid #000;
            border-radius: 5px;
            font-family: monospace;
            font-size: 16px;
            font-weight: bold;
            padding: 5px 10px;
            text-transform: uppercase;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .heading-table {
            margin-top: 10px;
            margin-bottom: 10px;
        }

        .heading-table tbody td {
            color: #000;
            vertical-align: middle;
            padding: 6px 0;
        }

        .body-table tbody td {
            color: #000;
            vertical-align: middle;
            border: 1px solid #000;
            text-align: center;
        }

        .footer-table {
            margin-top: 50px;
        }

        .footer-table span {
            border-top: 1px solid #000;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="header">
            <table class="table">
                <tbody>
                    <tr>
                        <td rowspan="2" width="20%" align="right">
                            <?php if ($this->global_setting->brand_logo) { ?>
                                <img src="<?php echo UPLOAD_PATH; ?>logo/<?php echo $this->global_setting->brand_logo; ?>" alt="logo">
                            <?php } else { ?>
                                <img src="<?php echo IMG_URL; ?>logo.png" alt="logo">
                            <?php } ?>
                        </td>
                        <td width="60%" align="center">
                            <h1><?php echo $this->global_setting->brand_title; ?></h1>
                            <p><?php echo $this->global_setting->address; ?></p>
                            <p><?php echo $this->global_setting->phone; ?></p>
                        </td>
                        <td width="20%"></td>
                    </tr>
                    <tr>
                        <td>
                            <div class="title" align="center">
                                <span>Debit Voucher</span>
                            </div>
                        </td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        </div>
        <!-- Header End -->

        <div class="body">
            <table class="table heading-table">
                <tbody>
                    <tr>
                        <td width="60%" align="left">
                            <strong>Debit : </strong>
                            Anesthesia
                        </td>
                        <td width="40%" align="right">
                            <strong>V. No.</strong>
                            <?php echo $patient->custom_invoice_id; ?>
                        </td>
                    </tr>
                    <tr>
                        <td align="left">
                            <strong>Paid to : </strong>
                            <?php echo $patient->doctor; ?>
                        </td>
                        <td align="right">
                            <strong>Date</strong>
                            <?php echo date('d M, Y h:ia', strtotime($patient->date)); ?>
                        </td>
                    </tr>
                </tbody>
            </table>
            <!-- Heading End -->
            <table class="table body-table">
                <tbody>
                    <tr>
                        <td colspan="2">
                            <strong>Particulars</strong>
                        </td>
                        <td colspan="2">
                            <strong>Amount</strong>
                        </td>
                    </tr>
                    <tr>
                        <td rowspan="2" colspan="2" height="140" style="vertical-align: top;">
                            <p style="margin: 0; padding: 10px; vertical-align: top; text-align: left;">
                                <?php echo $patient->note; ?>
                            </p>
                        </td>
                        <td height="20"><strong>Taka</strong></td>
                        <td><strong>Ps.</strong></td>
                    </tr>
                    <tr>
                        <td style="vertical-align: top;">
                            <?php echo $patient->payable_amount; ?>
                        </td>
                        <td></td>
                    </tr>
                    <tr>
                        <td width="60%" style="text-align: left;">
                            <strong>In Words:</strong>
                            <?php echo $this->numbertowords->convert_number($patient->payable_amount); ?> Taka Only.
                        </td>
                        <td width="10%" align="right">
                            <strong>Total</strong>
                        </td>
                        <td width="20%">
                            <?php echo $patient->payable_amount; ?>
                        </td>
                        <td width="10%"></td>
                    </tr>
                </tbody>
            </table>
            <!-- Body Table End -->
            <table class="table footer-table">
                <tbody>
                    <tr>
                        <td width="25%" align="left">
                            <span>Account's</span>
                        </td>
                        <td width="25%" align="center">
                            <span>Received by</span>
                        </td>
                        <td width="25%" align="center">
                            <span>Admin Officer</span>
                        </td>
                        <td width="25%" align="right">
                            <span>Project Director</span>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</body>

</html>