<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Incomehead_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_incomehead_list($limit, $offset, $search, $count) {
        $this->db->select('IH.*');
        $this->db->from('income_heads AS IH');
        if ($search) {
            $this->db->like('IH.name', $search);
            $this->db->or_like('IH.bn_name', $search);
            $this->db->or_like('IH.note', $search);
        }
        $this->db->order_by('IH.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }


    function duplicate_check($name, $id = null) {

        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('income_heads')->num_rows();
    }
}
