<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />

    <title><?php echo $this->lang->line('reset_password'); ?> <?php echo $this->global_setting->brand_title ? ' | ' . $this->global_setting->brand_title : ' | ' . TITLE;  ?></title>

    <!-- Favicon -->
    <?php if ($this->global_setting->favicon) { ?>
        <link rel="icon" href="<?php echo UPLOAD_PATH; ?>icon/<?php echo $this->global_setting->favicon; ?>" type="image/x-icon" />
    <?php } else { ?>
        <link rel="icon" href="<?php echo IMG_URL; ?>favicon.ico" type="image/x-icon" />
    <?php } ?>

    <meta name="title" content="<?php echo $this->global_setting->brand_name ? $this->global_setting->brand_name : TITLE;  ?>" />
    <meta name="description" content="<?php echo $this->global_setting->brand_title ? $this->global_setting->brand_title : TITLE;  ?>" />

    <!-- Bootstrap 4.5 -->
    <link rel="stylesheet" href="<?php echo VENDOR_URL; ?>bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo VENDOR_URL; ?>font-awesome/css/font-awesome.min.css">
    <!-- Owl CSS -->
    <link rel="stylesheet" href="<?php echo VENDOR_URL; ?>owl.carousel/dist/assets/owl.carousel.min.css">
    <link rel="stylesheet" href="<?php echo VENDOR_URL; ?>owl.carousel/dist/assets/owl.theme.default.min.css">
    <!-- Toastr CSS -->
    <link href="<?php echo VENDOR_URL; ?>toast/jquery.toast.min.css" rel="stylesheet" type="text/css">

    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo CSS_URL; ?>backend/style.css">
    <!-- Custom Theme Style -->
    <link href="<?php echo CSS_URL; ?>backend/custom.css" rel="stylesheet">
</head>

<body>

    <!-- HK Wrapper -->
    <div class="hk-wrapper">
        <!-- Main Content -->
        <div class="hk-pg-wrapper hk-auth-wrapper">
            <header class="d-flex justify-content-between align-items-center">
                <a class="d-flex text-white auth-brand" href="<?php echo site_url(); ?>">
                    <?php echo $this->global_setting->brand_title ? $this->global_setting->brand_title : TITLE;  ?>
                </a>
                <div class="btn-group btn-group-sm">
                    <a class="btn btn-gradient-primary" href="<?php echo base_url("language/english"); ?>"><?php echo $this->lang->line('english'); ?></a>
                    <a class="btn btn-gradient-success" href="<?php echo base_url("language/bengali"); ?>"><?php echo $this->lang->line('bengali'); ?></a>
                </div>
            </header>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-xl-5 pa-0">
                        <div id="login_slider" class="owl-carousel dots-on-item owl-theme">
                            <div class="fadeOut item auth-cover-img overlay-wrap" style="background-image:url(<?php echo IMG_URL; ?>slider/slider_1.jpg);">
                                <div class="auth-cover-info py-xl-0 pt-100 pb-50">
                                    <div class="auth-cover-content text-center w-xxl-75 w-sm-90 w-xs-100">
                                        <h1 class="display-3 text-white mb-20">Dedicated Customer Service</h1>
                                        <p class="text-white">We have an expert and dedicated customer support team in the head office who are always ready to support you. They listen to your queries and make solutions within a short time.</p>
                                    </div>
                                </div>
                                <div class="bg-overlay bg-trans-dark-50"></div>
                            </div>
                            <div class="fadeOut item auth-cover-img overlay-wrap" style="background-image:url(<?php echo IMG_URL; ?>slider/slider_2.jpg);">
                                <div class="auth-cover-info py-xl-0 pt-100 pb-50">
                                    <div class="auth-cover-content text-center w-xxl-75 w-sm-90 w-xs-100">
                                        <h1 class="display-3 text-white mb-20">Simple and Easy to Use</h1>
                                        <p class="text-white">CMS Management System is simple and easy to use which saves your time to store data digitally. Anyone with minimum knowledge of computers and internet can use this software.</p>
                                    </div>
                                </div>
                                <div class="bg-overlay bg-trans-dark-50"></div>
                            </div>
                            <div class="fadeOut item auth-cover-img overlay-wrap" style="background-image:url(<?php echo IMG_URL; ?>slider/slider_3.jpg);">
                                <div class="auth-cover-info py-xl-0 pt-100 pb-50">
                                    <div class="auth-cover-content text-center w-xxl-75 w-sm-90 w-xs-100">
                                        <h1 class="display-3 text-white mb-20">Fully Web-Based Application</h1>
                                        <p class="text-white">Our CMS is a fully web-based application. Therefore, it can be used with a browser from anywhere in the world.</p>
                                    </div>
                                </div>
                                <div class="bg-overlay bg-trans-dark-50"></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-7 pa-0">
                        <div class="auth-form-wrap py-xl-0 py-50">
                            <div class="auth-form w-xxl-55 w-xl-75 w-sm-90 w-xs-100">
                                <?php echo form_open(site_url('auth/resetpass'), array('name' => 'resetpass', 'id' => 'resetpass'), ''); ?>
                                <input type="hidden" name="username" value="<?php echo $user->username; ?>" />
                                <input type="hidden" name="id" value="<?php echo $user->id; ?>" />
                                <input type="hidden" name="key" value="<?php echo $key; ?>" />
                                <?php if ($this->global_setting->brand_logo) { ?>
                                    <img style="width: 100px;" class="img-fluid circle mx-auto d-block" src="<?php echo UPLOAD_PATH; ?>logo/<?php echo $this->global_setting->brand_logo; ?>" alt="<?php echo $this->global_setting->brand_name; ?>" title="<?php echo $this->global_setting->brand_title; ?>">
                                <?php } else { ?>
                                    <img style="width: 100px;" class="img-fluid circle mx-auto d-block" src="<?php echo IMG_URL; ?>logo.png" alt="logo" srcset="">
                                <?php } ?>
                                <p class="mt-10 mb-30 text-center"><?php echo $this->lang->line('reset_password'); ?></p>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-append">
                                            <button class="btn btn-primary" type="button"><i class="fa fa-lock"></i></button>
                                        </div>
                                        <input type="password" class="form-control" name="password" id="password" placeholder="<?php echo $this->lang->line('password'); ?>" required="required">
                                        <div class="help-block"><?php echo form_error('password'); ?></div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-append">
                                            <button class="btn btn-primary" type="button"><i class="fa fa-lock"></i></button>
                                        </div>
                                        <input type="password" class="form-control" name="conf_password" id="conf_password" placeholder="<?php echo $this->lang->line('conf_password'); ?>" required="required">
                                        <div class="help-block"><?php echo form_error('conf_password'); ?></div>
                                    </div>
                                </div>
                                <div class="custom-control mb-25">
                                    <a href="<?php echo site_url('admin') ?>" class="pull-right"><?php echo $this->lang->line('back_to_login'); ?></a>
                                </div>
                                <button class="btn btn-gradient-primary btn-block" type="submit"><?php echo $this->lang->line('submit') ?></button>
                                <?php echo form_close(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Main Content -->
    </div>
    <!-- /HK Wrapper -->

    <!-- jQuery -->
    <script src="<?php echo JS_URL; ?>jquery.min.js"></script>

    <!-- Bootstrap Core JavaScript -->
    <script src="<?php echo JS_URL; ?>popper.min.js"></script>
    <script src="<?php echo VENDOR_URL; ?>bootstrap/js/bootstrap.min.js"></script>

    <!-- Slimscroll JavaScript -->
    <script src="<?php echo JS_URL; ?>backend/jquery.slimscroll.js"></script>

    <!-- Owl JavaScript -->
    <script src="<?php echo VENDOR_URL; ?>owl.carousel/dist/owl.carousel.min.js"></script>
    <!-- Toastr JS -->
    <script src="<?php echo VENDOR_URL; ?>toast/jquery.toast.min.js"></script>
    <?php $this->load->view('layout/message'); ?>
    <script>
        $('#login_slider').owlCarousel({
            items: 1,
            animateOut: 'fadeOut',
            loop: true,
            margin: 10,
            autoplay: true,
            mouseDrag: false

        });
    </script>
</body>

</html>