<!-- Container -->
<div class="container-fluid">
    <!-- Row -->
    <div class="row">
        <div class="col-xl-12 pa-0">
            <!-- Profile Heading -->
            <?php $this->load->view('profile/header'); ?>
            <!-- Profile Body -->
            <!-- Container -->
            <div class="container mt-50">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h6 class="card-header d-flex align-items-center">
                                    <i class="fa fa-key font-30 mr-10"></i>
                                    <?php echo $this->lang->line('reset_password'); ?> <?php echo $this->lang->line('info'); ?>
                                </h6>
                                <div class="align-items-center">
                                    <a href="<?php echo site_url('dashboard'); ?>" class="btn btn-xs btn-primary">
                                        <i class="fa fa-dashboard font-12 mr-5"></i>
                                        <?php echo $this->lang->line('dashboard'); ?>
                                    </a>
                                </div>
                            </div>
                            <?php echo form_open_multipart(site_url('profile/password'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-6 mb-10">
                                        <label for="password"><?php echo $this->lang->line('password'); ?></label>
                                        <input type="password" class="form-control" name="password" id="password" value="" placeholder="<?php echo $this->lang->line('password'); ?>" required>
                                    </div>
                                    <div class="col-md-6 mb-10">
                                        <label for="conf_password"><?php echo $this->lang->line('confirm'); ?> <?php echo $this->lang->line('password'); ?></label>
                                        <input type="password" class="form-control" name="conf_password" id="conf_password" value="" placeholder="<?php echo $this->lang->line('confirm'); ?> <?php echo $this->lang->line('password'); ?>" required>
                                    </div>
                                </div>
                            </div>
                            <!-- Card Footer -->
                            <div class="card-footer pt-0">
                                <div class="button-list">
                                    <a class="btn btn-gradient-danger" href="<?php echo site_url('profile'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                                    <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                                </div>
                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
                <!-- /Row -->
            </div>
            <!-- /Container -->
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<script src="<?php echo JS_URL; ?>jquery.validate.js"></script>
<script type="text/javascript">
    $("#add").validate({
        rules: {
            password: {
                required: true,
                minlength: 6
            },
            conf_password: {
                required: true,
                minlength: 6,
                equalTo: "#password"
            }
        }
    });
</script>