<!-- Top Navbar -->
<nav class="navbar navbar-expand-xl fixed-top hk-navbar <?php echo $this->session->userdata('sidebar_nav') == 0 ? 'navbar-light' : 'navbar-dark'; ?>">
    <a id="navbar_toggle_btn" class="navbar-toggle-btn nav-link-hover" href="javascript:void(0);"><i class="fa fa-bars"></i></a>
    <a class="navbar-brand font-weight-700" href="<?php echo site_url('dashboard'); ?>">
        <?php echo $this->global_setting->brand_name; ?>
    </a>

    <div class="btn-group d-none d-md-block" style="margin-left: 7%;" role="group" aria-label="First group">
        <?php if (has_permission(ADD, 'frontoffice', 'appointment')) { ?>
            <a href="<?php echo site_url('frontoffice/appointment'); ?>" class="btn btn-sm btn-primary">
                <i class="fa fa-plus"></i>
                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('appointment'); ?>
            </a>
        <?php } ?>

        <?php if (has_permission(ADD, 'billing', 'billing')) { ?>
            <a href="<?php echo site_url('billing'); ?>" class="btn btn-sm btn-success">
                <i class="fa fa-plus"></i>
                <?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('bill'); ?>
            </a>
        <?php } ?>
    </div>
    <div class="nav notify-row d-none d-md-block">
        <ul class="nav">

            <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                <!-- Bed Notification start -->
                <li class="dropdown">
                    <a href="javascript:void(0);" onclick="getBedStatus()" data-toggle="modal" data-target="#bedModal">
                        <i class="fa fa-bed"></i>
                        <span class="badge badge-success"><?php echo $this->total_beds ?? 0; ?></span>
                    </a>
                </li>
                <!-- Bed notification end -->
            <?php } ?>

            <?php if (has_permission(VIEW, 'accounting', 'payment')) { ?>
                <!-- Payment notification start-->
                <li class="dropdown">
                    <a data-toggle="dropdown" href="#">
                        <i class="fa fa-money"></i>
                        <span class="badge badge-success">0</span>
                    </a>
                    <ul class="dropdown-menu extended">
                        <div class="notify-arrow notify-arrow-green"></div>
                        <li>
                            <p class="bg-green"> 0 Payment Today</p>
                        </li>
                        <li>
                            <a href="#">
                                <p class="bg-info"> See All Payments</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <!-- payment notification end -->
            <?php } ?>

            <?php if (has_permission(VIEW, 'patient', 'patient')) { ?>
                <!-- patient notification start-->
                <li class="dropdown">
                    <a data-toggle="dropdown" href="#">
                        <i class="fa fa-user"></i>
                        <span class="badge badge-orange"><?php echo $this->total_today_patient ?? 0; ?></span>
                    </a>
                    <ul class="dropdown-menu extended">
                        <div class="notify-arrow notify-arrow-orange"></div>
                        <li>
                            <p class="bg-orange"> <?php echo $this->total_today_patient ?? 0; ?> Patient Registered Today</p>
                        </li>
                        <li>
                            <a href="<?php echo site_url('patient'); ?>">
                                <p class="bg-info"> See All Patient</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <!-- patient notification end -->
            <?php } ?>

            <?php if (has_permission(VIEW, 'accounting', 'payment')) { ?>
                <!-- donor notification start-->
                <li class="dropdown">
                    <a data-toggle="dropdown" href="#">
                        <i class="fa fa-user-md"></i>
                        <span class="badge badge-violet">0</span>
                    </a>
                    <ul class="dropdown-menu extended">
                        <div class="notify-arrow notify-arrow-violet"></div>
                        <li>
                            <p class="bg-violet"> 0 Donor Registered Today</p>
                        </li>
                        <li>
                            <a href="#">
                                <p class="bg-info"> See All Donors</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <!-- donor notification end -->
            <?php } ?>

            <?php if (has_permission(VIEW, 'accounting', 'payment')) { ?>
                <!-- medicine notification start-->
                <li class="dropdown">
                    <a data-toggle="dropdown" href="#">
                        <i class="fa fa-medkit"></i>
                        <span class="badge badge-teal">0</span>
                    </a>
                    <ul class="dropdown-menu extended">
                        <div class="notify-arrow notify-arrow-teal"></div>
                        <li>
                            <p class="bg-teal"> 0 Medicine Registered Today</p>
                        </li>
                        <li>
                            <a href="#">
                                <p class="bg-info"> See All Medicines</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <!-- medicine notification end -->
            <?php } ?>
        </ul>
    </div>

    <ul class="navbar-nav hk-navbar-content">
        <?php if (has_permission(VIEW, 'message', 'balance')) { ?>
            <li class="text-white mr-3 d-none d-md-block">
                <i class="fa fa-money"></i>
                <?php echo get_sms_balance(); ?>
            </li>
        <?php } ?>
        <li>
            <a target="_blank" href="<?php echo site_url(); ?>"><i class="fa fa-globe"></i> <?php echo $this->lang->line('web'); ?></a>
        </li>
        <li class="nav-item">
            <a id="navbar_search_btn" class="nav-link nav-link-hover" href="javascript:void(0);"><i class="fa fa-search"></i></a>
        </li>
        <li class="nav-item">
            <a id="settings_toggle_btn" class="nav-link nav-link-hover" href="javascript:void(0);"><i class="fa fa-cogs"></i></a>
        </li>
        <li class="nav-item dropdown dropdown-notifications">
            <a class="nav-link dropdown-toggle no-caret" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa fa-bell"></i><span class="badge-wrap"><span class="badge badge-primary badge-indicator badge-indicator-sm badge-pill pulse"></span></span></a>
            <div class="dropdown-menu dropdown-menu-right" data-dropdown-in="fadeIn" data-dropdown-out="fadeOut">
                <h6 class="dropdown-header">Notifications <a href="javascript:void(0);" class="">View all</a></h6>
                <div class="notifications-nicescroll-bar">
                    <a href="javascript:void(0);" class="dropdown-item">
                        <div class="media">
                            <div class="media-img-wrap">
                                <div class="avatar avatar-sm">
                                    <img src="<?php echo IMG_URL; ?>male.png" alt="male" class="avatar-img rounded-circle">
                                </div>
                            </div>
                            <div class="media-body">
                                <div>
                                    <div class="notifications-text"><span class="text-dark text-capitalize">Rabiul Islam</span> accepted your invitation to join the team</div>
                                    <div class="notifications-time">12m</div>
                                </div>
                            </div>
                        </div>
                    </a>
                    <div class="dropdown-divider"></div>
                    <a href="javascript:void(0);" class="dropdown-item">
                        <div class="media">
                            <div class="media-img-wrap">
                                <div class="avatar avatar-sm">
                                    <img src="<?php echo IMG_URL; ?>female.png" alt="male" class="avatar-img rounded-circle">
                                </div>
                            </div>
                            <div class="media-body">
                                <div>
                                    <div class="notifications-text"><span class="text-dark text-capitalize">Nowsheen</span> accepted your invitation to join the team</div>
                                    <div class="notifications-time">20m</div>
                                </div>
                            </div>
                        </div>
                    </a>
                    <div class="dropdown-divider"></div>
                    <a href="javascript:void(0);" class="dropdown-item">
                        <div class="media">
                            <div class="media-img-wrap">
                                <div class="avatar avatar-sm">
                                    <img src="<?php echo IMG_URL; ?>male.png" alt="male" class="avatar-img rounded-circle">
                                </div>
                            </div>
                            <div class="media-body">
                                <div>
                                    <div class="notifications-text"><span class="text-dark text-capitalize">Eyasir Arafat</span> accepted your invitation to join the team</div>
                                    <div class="notifications-time">30m</div>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </li>
        <li class="nav-item dropdown dropdown-authentication">
            <a class="nav-link dropdown-toggle no-caret" href="javascript:void(0);" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <div class="media">
                    <div class="media-img-wrap">
                        <div class="avatar">
                            <?php if ($this->session->userdata('photo')) { ?>
                                <img src="<?php echo UPLOAD_PATH; ?>employee-photo/<?php echo $this->session->userdata('photo'); ?>" alt="<?php echo $this->session->userdata('name'); ?>" class="avatar-img rounded-circle">
                            <?php } elseif ($this->session->userdata('gender') == 'male') { ?>
                                <img src="<?php echo IMG_URL; ?>male.png" alt="male" class="avatar-img rounded-circle">
                            <?php } else { ?>
                                <img src="<?php echo IMG_URL; ?>female.png" alt="female" class="avatar-img rounded-circle">
                            <?php }  ?>
                        </div>
                        <span class="badge badge-success badge-indicator"></span>
                    </div>
                    <div class="media-body">
                        <span><?php echo $this->session->userdata('name'); ?><i class="fa fa-angle-down"></i></span>
                    </div>
                </div>
            </a>
            <div class="dropdown-menu dropdown-menu-right" data-dropdown-in="flipInX" data-dropdown-out="flipOutX">
                <a class="dropdown-item" href="<?php echo site_url('profile'); ?>"><i class="dropdown-icon fa fa-user"></i><span><?php echo $this->lang->line('my_profile'); ?></span></a>
                <a class="dropdown-item" href="<?php echo site_url('profile/password'); ?>"><i class="dropdown-icon fa fa-key"></i><span><span><?php echo $this->lang->line('password'); ?></span></a>
                <a class="dropdown-item" href="<?php echo site_url('auth/logout'); ?>"><i class="dropdown-icon fa fa-power-off"></i><span><?php echo $this->lang->line('logout'); ?></span></a>
            </div>
        </li>
    </ul>
</nav>
<form role="search" class="navbar-search">
    <div class="position-relative">
        <a href="javascript:void(0);" class="navbar-search-icon"><i class="fa fa-search"></i></a>
        <input type="text" name="search" class="form-control" placeholder="Type here to Search">
        <a id="navbar_search_close" class="navbar-search-close" href="#"><i class="fa fa-times"></i></a>
    </div>
</form>
<!-- /Top Navbar -->

<!-- Bed Modal -->
<div class="modal fade" id="bedModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white" id="exampleModalLabel">
                    <i class="fa fa-bed"></i>
                    <?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('list'); ?>
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body bg-gradient-secondary p-0">
                <div class="table-wrap">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <tbody>
                                <?php if (isset($floors) & !empty($floors)) { ?>
                                    <?php foreach ($floors as $floor) { ?>
                                        <?php $bed_groups = $this->dashboard->get_list('bed_groups', array('status' => 1, 'floor_id' => $floor->id), '', '', '', 'sort_by', 'ASC'); ?>
                                        <tr>
                                            <td class="bg-gradient-pony">
                                                <span class="text-white font-25 font-weight-bold">
                                                    <?php echo $floor->name; ?> <?php echo ' - ' . $floor->bn_name ?? ''; ?>
                                                </span>
                                            </td>
                                        </tr>
                                        <?php foreach ($bed_groups as $group) { ?>
                                            <?php $bed_lists = $this->dashboard->get_bed_list($group->id); ?>
                                            <tr>
                                                <td class="bg-gradient-ashes text-center">
                                                    <span class="text-white font-20 font-weight-bold">
                                                        <?php echo $group->name; ?> <?php echo ' - ' . $group->bn_name ?? ''; ?>
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="row">
                                                        <?php foreach ($bed_lists as $bed) {
                                                            $_patient = $this->dashboard->get_ipd_patient_info($bed->group_id, $bed->id);
                                                        ?>
                                                            <div class="col-lg-2 col-md-2 col-sm-6">
                                                                <div class="card card-sm">
                                                                    <div class="card-body pt-5 pr-5 pl-5 pb-5">
                                                                        <div class="row d-flex align-items-center justify-content-center">
                                                                            <div class="col-md-6 text-left">
                                                                                <?php if ($bed->is_active == 1) { ?>
                                                                                    <i class="fa fa-bed font-50 text-red"></i>
                                                                                <?php } else if ($bed->is_active == 2) { ?>
                                                                                    <i class="fa fa-bed font-50 text-warning"></i>
                                                                                <?php } else { ?>
                                                                                    <i class="fa fa-bed font-50 text-green"></i>
                                                                                <?php } ?>
                                                                            </div>
                                                                            <?php if ($bed->is_active == 1) { ?>
                                                                                <div class="col-md-6 text-right">
                                                                                    <a title="<?php echo $_patient->patient_name; ?>" href="<?php echo site_url('ipd/profile/' . $_patient->ipd_id); ?>" class="btn btn-primary btn-sm">
                                                                                        <i class="fa fa-link" aria-hidden="true"></i>
                                                                                    </a>
                                                                                </div>
                                                                            <?php } else if ($bed->is_active == 2) { ?>
                                                                                <div class="col-md-6 text-right">
                                                                                    <a title="This bed is now Booking" href="<?php echo site_url('ipd/booking'); ?>" class="btn btn-warning btn-sm">
                                                                                        <i class="fa fa-link" aria-hidden="true"></i>
                                                                                    </a>
                                                                                </div>
                                                                            <?php } else { ?>
                                                                                <span>&nbsp;</span>
                                                                            <?php } ?>
                                                                            <div class="col-md-12 text-center">
                                                                                <span class="d-block font-weight-bold text-dark">
                                                                                    <?php echo $bed->name; ?>
                                                                                </span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php } ?>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    <?php } ?>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>