<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('sms'); ?> <?php echo $this->lang->line('template'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('sms'); ?> <?php echo $this->lang->line('template'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'setting', 'smstemplate')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-bell-o font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('template'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'setting', 'smstemplate')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('setting/smstemplate'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list"></i>
                                <?php echo $this->lang->line('template'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <?php echo form_open_multipart(site_url('setting/smstemplate/edit/' . $template->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="role_id"><?php echo $this->lang->line('user_role'); ?></label>
                            <select class="form-control custom-select" name="role_id" id="role_id" required onchange="get_tag_by_role(this.value, 'add');">
                                <option value="">--<?php echo $this->lang->line('select'); ?> --</option>
                                <?php foreach ($roles as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($template->role_id) && $template->role_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select text-uppercase" name="type" id="type" required>
                                <option value="">--<?php echo $this->lang->line('select'); ?> --</option>
                                <?php foreach ($types as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($template->type) && $template->type == $obj->id ? 'selected="selected"' : ""; ?>><?php echo str_replace(array('_', '-', '--'), ' ', $obj->type); ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="type" class="form-text text-muted">
                                <?php echo form_error('type'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="title"><?php echo $this->lang->line('title'); ?></label>
                            <input type="text" class="form-control" name="title" id="title" value="<?php echo isset($template->title) ?  $template->title : ''; ?>" placeholder="<?php echo $this->lang->line('template'); ?> <?php echo $this->lang->line('title'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mb-10">
                            <label for="template"><?php echo $this->lang->line('template'); ?></label>
                            <textarea class="form-control" rows="8" name="template" id="template" placeholder="<?php echo $this->lang->line('template'); ?>"><?php echo isset($template->template) ?  $template->template : ''; ?></textarea>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('template'); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mb-10">
                            <label for="template"><?php echo $this->lang->line('dynamic_tag'); ?></label>
                            <div id="fn_add_tag"></div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" value="<?php echo $template->id; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('setting/smstemplate'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<script type="text/javascript">
    <?php if (isset($template) && !empty($template)) { ?>
        get_tag_by_role('<?php echo $template->role_id ?>', 'add');
    <?php } ?>

    function get_tag_by_role(role_id, type) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_tag_by_role'); ?>",
            data: {
                role_id: role_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#fn_' + type + '_tag').html(response);
                }
            }
        });
    }
</script>