<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('reset_user_password'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('reset_user_password'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <h6 class="card-header d-flex align-items-center">
                        <i class="fa fa-key font-30 mr-10"></i>
                        <?php echo $this->lang->line('reset_user_password'); ?>
                    </h6>
                    <div class="align-items-center">
                        <a href="<?php echo site_url('dashboard'); ?>" class="btn btn-xs btn-primary">
                            <i class="fa fa-dashboard"></i>
                            <?php echo $this->lang->line('dashboard'); ?>
                        </a>
                    </div>
                </div>
                <?php echo form_open_multipart(site_url('setting/password'), array('name' => 'password', 'id' => 'password', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="role_id"><?php echo $this->lang->line('user'); ?> <?php echo $this->lang->line('role'); ?></label>
                            <select class="form-control custom-select" name="role_id" id="role_id" onchange="get_user_by_role(this.value, '', '');" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($roles as $obj) { ?>
                                    <?php if ($this->session->userdata('role_id') != SUPER_ADMIN) { ?>
                                        <?php if (in_array($obj->id, array(SUPER_ADMIN))) {
                                            continue;
                                        } ?>
                                    <?php } ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($role_id) && $role_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="user_id"><?php echo $this->lang->line('user'); ?></label>
                            <select class="form-control custom-select" name="user_id" id="user_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="password"><?php echo $this->lang->line('password'); ?></label>
                            <input type="password" class="form-control" name="password" id="password" value="<?php echo isset($password) ?  $password : ''; ?>" placeholder="<?php echo $this->lang->line('password'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="password" class="form-text text-muted">
                                <?php echo form_error('password'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="conf_password"><?php echo $this->lang->line('conf_password'); ?></label>
                            <input type="password" class="form-control" name="conf_password" id="conf_password" value="<?php echo isset($conf_password) ?  $conf_password : ''; ?>" placeholder="<?php echo $this->lang->line('conf_password'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="conf_password" class="form-text text-muted">
                                <?php echo form_error('conf_password'); ?>
                            </small>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<script>
    <?php if (isset($role_id)) { ?>
        get_user_by_role('<?php echo $role_id;  ?>', '<?php echo $user_id; ?>');
    <?php } ?>

    function get_user_by_role(role_id, user_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_user_by_role'); ?>",
            data: {
                role_id: role_id,
                user_id: user_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#user_id').html(response);
                }
            }
        });
    }
</script>