<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('module'); ?> <?php echo $this->lang->line('setting'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_module'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'setting', 'module')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-modx font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('module'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'setting', 'module')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('setting/module'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list"></i>
                                <?php echo $this->lang->line('module'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('setting/module/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-5 mb-10">
                            <label for="module_name"><?php echo $this->lang->line('module'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="module_name" id="module_name" value="<?php echo isset($module_name) ?  $module_name : ''; ?>" placeholder="<?php echo $this->lang->line('module'); ?> <?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('module_name'); ?>
                            </div>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="module_slug"><?php echo $this->lang->line('module'); ?> <?php echo $this->lang->line('slug'); ?></label>
                            <input type="text" class="form-control" name="module_slug" id="module_slug" value="<?php echo isset($module_slug) ?  $module_slug : ''; ?>" placeholder="<?php echo $this->lang->line('module'); ?> <?php echo $this->lang->line('slug'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('module_slug'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="status"><?php echo $this->lang->line('status'); ?></label>
                            <select class="form-control custom-select" name="status" id="status">
                                <option value="1" <?php echo isset($status) && $status == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('active'); ?></option>
                                <option value="0" <?php echo isset($status) && $status == 0 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('in_active'); ?></option>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('status'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('setting/module'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->