<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('backup'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('database'); ?> <?php echo $this->lang->line('backup'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-lg-9 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <h6 class="card-header d-flex align-items-center">
                        <i class="fa fa-database font-30 mr-10"></i>
                        <?php echo $this->lang->line('database'); ?> <?php echo $this->lang->line('backup'); ?>
                    </h6>

                    <?php echo form_open_multipart(site_url('setting/backup'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>" required>
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>

                    <?php if (has_permission(ADD, 'setting', 'backup')) { ?>
                        <div class="align-items-center">
                            <?php echo form_open_multipart(site_url('setting/backup'), array('name' => 'backup', 'id' => 'backup', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                            <input type="hidden" name="backup" value="">
                            <button class="btn btn-xs btn-primary" type="submit"><i class="fa fa-plus" aria-hidden="true"></i> <?php echo $this->lang->line('generate'); ?></button>
                            <?php echo form_close(); ?>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('created'); ?></th>
                                        <th><?php echo $this->lang->line('time'); ?></th>
                                        <th><?php echo $this->lang->line('download'); ?></th>
                                        <th><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($backups) && !empty($backups)) { ?>
                                        <?php foreach ($backups as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count++; ?></td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td><?php echo date($this->global_setting->date_format, strtotime($obj->created_at)); ?></td>
                                                <td><?php echo date($this->global_setting->time_format, strtotime($obj->created_at)); ?></td>
                                                <th>
                                                    <a class="btn btn-success btn-xs" href="<?php echo ASSET_URL; ?>backup/<?php echo $obj->location; ?>"><i class="fa fa-download" aria-hidden="true"></i> <?php echo $this->lang->line('download'); ?></a>
                                                </th>
                                                <td>
                                                    <?php if (has_permission(DELETE, 'setting', 'backup')) { ?>
                                                        <a href="<?php echo site_url('setting/backup/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-red"></i> </a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="6"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->