<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Permission.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Permission
 * @description     : Manage system user role permission by administrator.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Permission extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Role_Model', 'role', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "permission setting" user interface
     *                    and setting user role permission
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(EDIT);
        // now we need to add new permission
        if ($_POST) {
            if (count($this->input->post('operation')) > 0) {
                $role_id = $this->input->post('role_id');
                foreach ($this->input->post('operation') as $key => $value) {
                    $data = array();

                    $data['role_id'] = $role_id;
                    $data['operation_id'] = $key;
                    $data['is_add'] = isset($_POST['is_add'][$key]) && !empty($_POST['is_add'][$key]) ? $_POST['is_add'][$key] : 0;
                    $data['is_edit'] = isset($_POST['is_edit'][$key]) && !empty($_POST['is_edit'][$key]) ? $_POST['is_edit'][$key] : 0;
                    $data['is_delete'] = isset($_POST['is_delete'][$key]) && !empty($_POST['is_delete'][$key]) ? $_POST['is_delete'][$key] : 0;
                    $data['is_view'] = isset($_POST['is_view'][$key]) && !empty($_POST['is_view'][$key]) ? $_POST['is_view'][$key] : 0;
                    $data['status'] = 1;
                    $data['created_at'] = date('Y-m-d H:i:s');
                    $data['created_by'] = logged_in_user_id();

                    $exist = $this->role->get_single('privileges', array('role_id' => $role_id, 'operation_id' => $key));
                    if ($exist) {
                        $this->role->update('privileges', $data, array('role_id' => $role_id, 'operation_id' => $key));
                    } else {
                        $this->role->insert('privileges', $data);
                    }
                }

                // update config file
                $this->update_config();

                success($this->lang->line('update_success'));
                $role = $this->role->get_single('roles', array('id' => $role_id));
                create_log('Has been setting permission for the role : ' . $role->name);
                redirect('setting/permission/index/' . $role_id);
            }
        }

        $search = $this->input->get('search');
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('doctor/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->role->get_role_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['roles'] = $this->role->get_role_list($config['per_page'], $offset, $search, $count = FALSE);

        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['modules'] = $this->role->get_list('modules', array('status' => 1), '', '', '', 'id', 'ASC');


        $this->data['role_id'] = $this->uri->segment(4);
        if (!$this->data['role_id']) {
            $this->data['list'] = TRUE;
        } else {
            $this->data['role'] = $this->role->get_single('roles', array('id' => $this->data['role_id']));
            $this->data['permission'] = TRUE;
        }

        $this->layout->title($this->lang->line('role_permission') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('role/permission', $this->data);
    }
}
