<!DOCTYPE html>
<html>

<head>
    <title>IPD</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tfoot th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }

        .mt-3 {
            margin-top: 20px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">HOSPITAL IPD REPORT</h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="80%" align="left">
                                <b>Report:</b>
                                <span style="font-size: 12px; margin: 0; padding: 0;">
                                    All
                                </span>
                            </td>
                            <td width="20%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('M d, Y h:ia'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content mt-3 mb-0" style="width:30%; float:right;">
                    <thead>
                        <tr>
                            <th>Total Income</th>
                            <th><?php echo ($total_ipd_invoices + $total_ipd_advance_payments + $total_ipd_due_invoices + $total_ipd_other_incomes); ?></th>
                        </tr>
                        <tr>
                            <th>Total Expense</th>
                            <th><?php echo ($total_surgeons + $total_anesthetists + $total_assistants + $total_ipd_other_expenses); ?></th>
                        </tr>
                        <tr>
                            <th>Total Balance</th>
                            <th><?php echo (($total_ipd_invoices + $total_ipd_advance_payments + $total_ipd_due_invoices + $total_ipd_other_incomes) - ($total_surgeons + $total_anesthetists + $total_assistants + $total_ipd_other_expenses)); ?></th>
                        </tr>
                    </thead>
                </table>
                <!-- IPD Income -->
                <table class="table table_content mt-3 mb-0">
                    <thead>
                        <tr>
                            <th colspan="8" class="bg-light text-center">IPD Income</th>
                        </tr>
                        <tr>
                            <th>Patient ID</th>
                            <th>Patient Name</th>
                            <th>Doctor</th>
                            <th>Reference</th>
                            <th>Total</th>
                            <th>Discount</th>
                            <th>Paid</th>
                            <th>Due</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $total_count = 0;
                        $total_bill = 0;
                        $total_discount = 0;
                        $total_amount = 0;
                        $total_due_amount = 0;
                        foreach ($ipd_invoices as $obj) {
                            $total_count += 1;
                            $total_bill += $obj->total_bill;
                            $total_discount += $obj->discount;
                            $total_amount += $obj->amount;
                            $total_due_amount += $obj->due_amount;
                        ?>
                            <tr>
                                <td><?php echo $obj->patient_unique_id; ?></td>
                                <td><?php echo $obj->patient_name; ?></td>
                                <td><?php echo $obj->doctor; ?></td>
                                <td><?php echo $obj->reference; ?></td>
                                <td><?php echo $obj->total_bill; ?></td>
                                <td><?php echo $obj->discount; ?></td>
                                <td><?php echo $obj->amount; ?></td>
                                <td><?php echo $obj->due_amount; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th align="right" colspan="4">
                                <?php echo $this->lang->line('total'); ?> -
                                <?php echo $total_count; ?>
                            </th>
                            <th><?php echo $total_bill; ?></th>
                            <th><?php echo $total_discount; ?></th>
                            <th><?php echo $total_amount; ?></th>
                            <th><?php echo $total_due_amount; ?></th>
                        </tr>
                    </tfoot>
                </table>

                <!-- due investigations -->
                <table class="table table_content mt-3 mb-0">
                    <thead>
                        <tr>
                            <th colspan="5" class="bg-light text-center">IPD Advance Collection</th>
                        </tr>
                        <tr>
                            <th>Patient ID</th>
                            <th>Patient Name</th>
                            <th>Date</th>
                            <th>Created By</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $total_count = 0;
                        $total_amount = 0;
                        foreach ($ipd_advance_payments as $obj) {
                            $total_count += 1;
                            $total_amount += $obj->amount;
                        ?>
                            <tr>
                                <td><?php echo $obj->patient_unique_id; ?></td>
                                <td><?php echo $obj->patient_name; ?></td>
                                <td><?php echo date('d/m/Y h:ia', strtotime($obj->payment_date)); ?></td>
                                <td><?php echo $obj->creator; ?></td>
                                <td><?php echo $obj->amount; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th align="right" colspan="4">
                                <?php echo $this->lang->line('total'); ?> -
                                <?php echo $total_count; ?>
                            </th>
                            <th><?php echo $total_amount; ?></th>
                        </tr>
                    </tfoot>
                </table>

                <!-- due investigations -->
                <table class="table table_content mt-3 mb-0">
                    <thead>
                        <tr>
                            <th colspan="5" class="bg-light text-center">Due Collection</th>
                        </tr>
                        <tr>
                            <th>Patient ID</th>
                            <th>Patient Name</th>
                            <th>Date</th>
                            <th>Created By</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $total_count = 0;
                        $total_amount = 0;
                        foreach ($ipd_due_invoices as $obj) {
                            $total_count += 1;
                            $total_amount += $obj->amount;
                        ?>
                            <tr>
                                <td><?php echo $obj->patient_unique_id; ?></td>
                                <td><?php echo $obj->patient_name; ?></td>
                                <td><?php echo date('d/m/Y h:ia', strtotime($obj->payment_date)); ?></td>
                                <td><?php echo $obj->creator; ?></td>
                                <td><?php echo $obj->amount; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th align="right" colspan="4">
                                <?php echo $this->lang->line('total'); ?> -
                                <?php echo $total_count; ?>
                            </th>
                            <th><?php echo $total_amount; ?></th>
                        </tr>
                    </tfoot>
                </table>

                <!-- due investigations -->
                <table class="table table_content mt-3 mb-0">
                    <thead>
                        <tr>
                            <th colspan="5" class="bg-light text-center">IPD Income</th>
                        </tr>
                        <tr>
                            <th>Income Head</th>
                            <th>Name</th>
                            <th>Payment Method</th>
                            <th>Amount</th>
                            <th>Created By</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $total_count = 0;
                        $total_amount = 0;
                        foreach ($ipd_other_incomes as $obj) {
                            $total_count += 1;
                            $total_amount += $obj->amount;
                        ?>
                            <tr>
                                <td><?php echo $obj->income_head; ?></td>
                                <td><?php echo $obj->name; ?></td>
                                <td><?php echo $obj->payment_method; ?></td>
                                <td><?php echo $obj->amount; ?></td>
                                <td><?php echo $obj->creator; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th align="right" colspan="3">
                                <?php echo $this->lang->line('total'); ?> -
                                <?php echo $total_count; ?>
                            </th>
                            <th colspan="2"><?php echo $total_amount; ?></th>
                        </tr>
                    </tfoot>
                </table>

                <!-- IPD Other Income -->
                <table class="table table_content mt-3 mb-0">
                    <thead>
                        <tr>
                            <th colspan="5" class="bg-light text-center">Surgeon Payment</th>
                        </tr>
                        <tr>
                            <th>Patient ID</th>
                            <th>Patient Name</th>
                            <th>Doctor</th>
                            <th>Charge</th>
                            <th>Payment</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $total_count = 0;
                        $total_doctor_charge = 0;
                        $total_payment = 0;
                        foreach ($surgeons as $obj) {
                            $total_count += 1;
                            $total_doctor_charge += $obj->commission_amount;
                            $total_payment += $obj->payable_amount;
                        ?>
                            <tr>
                                <td><?php echo $obj->patient_unique_id; ?></td>
                                <td><?php echo $obj->patient_name; ?></td>
                                <td><?php echo $obj->doctor; ?></td>
                                <td><?php echo $obj->commission_amount; ?></td>
                                <td><?php echo $obj->payable_amount; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th align="right" colspan="3">
                                <?php echo $this->lang->line('total'); ?> -
                                <?php echo $total_count; ?>
                            </th>
                            <th><?php echo $total_doctor_charge; ?></th>
                            <th><?php echo $total_payment; ?></th>
                        </tr>
                    </tfoot>
                </table>



                <!-- Surgeon -->
                <table class="table table_content mt-3 mb-0">
                    <thead>
                        <tr>
                            <th colspan="5" class="bg-light text-center">Anesthesia Payment</th>
                        </tr>
                        <tr>
                            <th>Patient ID</th>
                            <th>Patient Name</th>
                            <th>Doctor</th>
                            <th>Charge</th>
                            <th>Payment</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $total_count = 0;
                        $total_doctor_charge = 0;
                        $total_payment = 0;
                        foreach ($anesthetists as $obj) {
                            $total_count += 1;
                            $total_doctor_charge += $obj->commission_amount;
                            $total_payment += $obj->payable_amount;
                        ?>
                            <tr>
                                <td><?php echo $obj->patient_unique_id; ?></td>
                                <td><?php echo $obj->patient_name; ?></td>
                                <td><?php echo $obj->doctor; ?></td>
                                <td><?php echo $obj->commission_amount; ?></td>
                                <td><?php echo $obj->payable_amount; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th align="right" colspan="3">
                                <?php echo $this->lang->line('total'); ?> -
                                <?php echo $total_count; ?>
                            </th>
                            <th><?php echo $total_doctor_charge; ?></th>
                            <th><?php echo $total_payment; ?></th>
                        </tr>
                    </tfoot>
                </table>


                <!-- anesthetists -->
                <table class="table table_content mt-3 mb-0">
                    <thead>
                        <tr>
                            <th colspan="5" class="bg-light text-center">Assistant Payment</th>
                        </tr>
                        <tr>
                            <th>Patient ID</th>
                            <th>Patient Name</th>
                            <th>Doctor</th>
                            <th>Charge</th>
                            <th>Payment</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $total_count = 0;
                        $total_doctor_charge = 0;
                        $total_payment = 0;
                        foreach ($assistants as $obj) {
                            $total_count += 1;
                            $total_doctor_charge += $obj->commission_amount;
                            $total_payment += $obj->payable_amount;
                        ?>
                            <tr>
                                <td><?php echo $obj->patient_unique_id; ?></td>
                                <td><?php echo $obj->patient_name; ?></td>
                                <td><?php echo $obj->doctor; ?></td>
                                <td><?php echo $obj->commission_amount; ?></td>
                                <td><?php echo $obj->payable_amount; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th align="right" colspan="3">
                                <?php echo $this->lang->line('total'); ?> -
                                <?php echo $total_count; ?>
                            </th>
                            <th><?php echo $total_doctor_charge; ?></th>
                            <th><?php echo $total_payment; ?></th>
                        </tr>
                    </tfoot>
                </table>

                <!-- assistants -->
                <table class="table table_content mt-3 mb-0">
                    <thead>
                        <tr>
                            <th colspan="5" class="bg-light text-center">IPD Expenses</th>
                        </tr>
                        <tr>
                            <th>Expense Head</th>
                            <th>Name</th>
                            <th>Payment Method</th>
                            <th>Amount</th>
                            <th>Created By</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $total_count = 0;
                        $total_amount = 0;
                        foreach ($ipd_other_expenses as $obj) {
                            $total_count += 1;
                            $total_amount += $obj->amount;
                        ?>
                            <tr>
                                <td><?php echo $obj->income_head; ?></td>
                                <td><?php echo $obj->name; ?></td>
                                <td><?php echo $obj->payment_method; ?></td>
                                <td><?php echo $obj->amount; ?></td>
                                <td><?php echo $obj->creator; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th align="right" colspan="3">
                                <?php echo $this->lang->line('total'); ?> -
                                <?php echo $total_count; ?>
                            </th>
                            <th colspan="2"><?php echo $total_amount; ?></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <!-- Content End -->

            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Printed By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>