<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('income'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php echo $this->load->view('marketing/header'); ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/marketing/income'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select select2" name="type" id="type">
                                <option value="test" <?php echo isset($type) && $type == 'test' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('test'); ?></option>
                                <option value="opd" <?php echo isset($type) && $type == 'opd' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('opd'); ?></option>
                                <option value="ipd" <?php echo isset($type) && $type == 'ipd' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('ipd'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?></label>
                            <select class="form-control custom-select select2" name="doctor_id" id="doctor_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="reference_id"><?php echo $this->lang->line('reference'); ?></label>
                            <select class="form-control custom-select select2" name="reference_id" id="reference_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('reference'); ?></option>
                                <?php foreach ($references as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_id) && $reference_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <?php if ($this->session->userdata('role_id') != MARKETING) { ?>
                            <div class="col-md-2 mb-10">
                                <label for="commission"><?php echo $this->lang->line('commission'); ?></label>
                                <select class="form-control custom-select select2" name="commission" id="commission">
                                    <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('commission'); ?></option>
                                    <option value="1" <?php echo isset($commission) && $commission == '1' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('commission'); ?> <?php echo $this->lang->line('yes'); ?></option>
                                    <option value="2" <?php echo isset($commission) && $commission == '2' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('no'); ?> <?php echo $this->lang->line('commission'); ?></option>
                                </select>
                            </div>
                            <div class="col-md-4 mb-10">
                                <label for="created_by"><?php echo $this->lang->line('created_by'); ?>*</label>
                                <select class="form-control custom-select select2" name="created_by" id="created_by" required>
                                    <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                    <?php foreach ($employees as $obj) { ?>
                                        <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                    <?php } ?>
                                </select>
                            </div>
                        <?php } else { ?>
                            <input type="hidden" name="created_by" value="<?php echo $this->session->userdata('user_id'); ?>">
                        <?php }  ?>
                        <div class="col-md-2">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if (isset($marketings) && !empty($marketings)) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'marketing')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-user font-30 mr-10"></i>
                                <?php echo $this->lang->line('marketing'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <div class="button-list">
                            <a href="<?php echo site_url('report/marketing/income_pdf/?type=' . $type . '&keyword=' . $keyword . '&date=' . $date . '&doctor_id=' . $doctor_id . '&reference_id=' . $reference_id . '&commission=' . $commission . '&created_by=' . $created_by); ?>" class="btn btn-success btn-xs">
                                <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('appointment_no'); ?></th>
                                            <th class="w-15"><?php echo $this->lang->line('date'); ?></th>
                                            <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('doctor'); ?></th>
                                            <th><?php echo $this->lang->line('reference'); ?></th>
                                            <?php if ($commission == 1) { ?>
                                                <th><?php echo $this->lang->line('commission'); ?></th>
                                            <?php } ?>
                                            <?php if ($type == 'opd') { ?>
                                                <th><?php echo $this->lang->line('opd'); ?></th>
                                            <?php } ?>

                                            <?php if ($type == 'ipd') { ?>
                                                <th><?php echo $this->lang->line('ipd'); ?></th>
                                            <?php } ?>

                                            <?php if ($type == 'test') { ?>
                                                <th><?php echo $this->lang->line('billing'); ?></th>
                                            <?php } ?>
                                            <th><?php echo $this->lang->line('action'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        $total_opd_amount = 0;
                                        $total_ipd_amount = 0;
                                        $total_test_amount = 0;
                                        $total_commission_amount = 0;
                                        $total_payable_commission = 0;
                                        $total_discount = 0;
                                        if (isset($marketings) && !empty($marketings)) { ?>
                                            <?php foreach ($marketings as $obj) {
                                                if ($type == 'opd') {
                                                    $total_opd_amount += $obj->doctor_charge;
                                                } elseif ($type == 'ipd') {
                                                    $total_ipd_amount += $obj->net_payable;
                                                } else {
                                                    $total_test_amount += $obj->net_payable;
                                                    $total_commission_amount += $obj->commission_amount;
                                                    $total_payable_commission += $obj->payable_commission;
                                                    $total_discount += $obj->discount;
                                                }
                                            ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <td><?php echo $obj->appointment_no; ?></td>
                                                    <td>
                                                        <div class="d-flex flex-column w-100">
                                                            <span>
                                                                <b>APP Date: </b> <?php echo date('d/m/Y', strtotime($obj->appointment_date)); ?>
                                                            </span>
                                                            <span>
                                                                <?php if ($type == 'opd') { ?>
                                                                    <b>Bill Date: </b> <?php echo date('d/m/Y', strtotime($obj->bill_date)); ?>
                                                                <?php } else if ($type == 'ipd') { ?>
                                                                    <b>Bill Date: </b> <?php echo date('d/m/Y', strtotime($obj->bill_date)); ?>
                                                                <?php } else { ?>
                                                                    <b>Bill Date: </b> <?php echo date('d/m/Y', strtotime($obj->bill_date)); ?>
                                                                <?php } ?>
                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <?php echo $obj->patient_name; ?><br>
                                                        <?php echo $obj->patient_unique_id; ?>
                                                    </td>
                                                    <td><?php echo $obj->doctor; ?></td>
                                                    <td><?php echo $obj->reference; ?></td>
                                                    <?php if ($commission == 1) { ?>
                                                        <td>
                                                            <?php echo number_format(($obj->payable_commission - $obj->discount), 0); ?> /
                                                            <?php echo number_format($obj->commission_amount, 0); ?>
                                                        </td>
                                                    <?php } ?>
                                                    <?php if ($type == 'opd') { ?>
                                                        <td><?php echo $obj->doctor_charge; ?></td>
                                                        <td>
                                                            <?php if (has_permission(VIEW, 'OPD', 'OPD')) { ?>
                                                                <a title="OPD View" href="<?php echo site_url('opd/profile/' . $obj->patient_id); ?>" class="btn btn-xs btn-info" target="_blank">
                                                                    <i class="fa fa-info"></i>
                                                                </a>
                                                            <?php } ?>
                                                            <button title="Appointment View" type="button" onclick="get_view_modal(<?php echo $obj->appointment_id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                                <i class="fa fa-eye"></i>
                                                            </button>
                                                        </td>
                                                    <?php } ?>

                                                    <?php if ($type == 'ipd') { ?>
                                                        <td><?php echo $obj->net_payable; ?></td>
                                                        <td>
                                                            <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                                                                <a title="Invoice View" href="<?php echo site_url('ipd/invoice/' . $obj->ipd_id . '/' . $obj->invoice_id); ?>" class="btn btn-xs btn-info" target="_blank">
                                                                    <i class="fa fa-info"></i>
                                                                </a>
                                                            <?php } ?>
                                                            <button title="Appointment View" type="button" onclick="get_view_modal(<?php echo $obj->appointment_id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                                <i class="fa fa-eye"></i>
                                                            </button>
                                                        </td>
                                                    <?php } ?>

                                                    <?php if ($type == 'test') { ?>
                                                        <td><?php echo $obj->net_payable; ?></td>
                                                        <td>
                                                            <?php if (has_permission(VIEW, 'billing', 'billing')) { ?>
                                                                <a title="Invoice View" href="<?php echo site_url('billing/invoice/' . $obj->invoice_id); ?>" class="btn btn-xs btn-info" target="_blank">
                                                                    <i class="fa fa-info"></i>
                                                                </a>
                                                            <?php } ?>
                                                            <button title="Appointment View" type="button" onclick="get_view_modal(<?php echo $obj->appointment_id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                                <i class="fa fa-eye"></i>
                                                            </button>
                                                        </td>
                                                    <?php } ?>
                                                </tr>
                                            <?php } ?>

                                            <?php if ($type == 'opd') { ?>
                                                <tr class="bg-transparent">
                                                    <td colspan="7" class="text-right text-light">Total OPD Amount</td>
                                                    <td colspan="2" class="text-right"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_opd_amount, 2); ?></td>
                                                </tr>
                                            <?php } ?>

                                            <?php if ($type == 'ipd') { ?>
                                                <tr class="bg-transparent">
                                                    <td colspan="7" class="text-right text-light border-top-0">Total IPD Amount</td>
                                                    <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_ipd_amount, 2); ?></td>
                                                </tr>
                                            <?php } ?>

                                            <?php if ($type == 'test' && $commission == 1) { ?>
                                                <tr class="bg-transparent">
                                                    <td colspan="8" class="text-right text-light border-top-0">Total Commission Amount</td>
                                                    <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_commission_amount, 2); ?></td>
                                                </tr>
                                                <tr class="bg-transparent">
                                                    <td colspan="8" class="text-right text-light border-top-0">Total Payable Commission Amount</td>
                                                    <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_payable_commission - $total_discount, 2); ?></td>
                                                </tr>
                                                <tr class="bg-transparent">
                                                    <td colspan="8" class="text-right text-light border-top-0">Total Test Amount</td>
                                                    <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_test_amount, 2); ?></td>
                                                </tr>
                                            <?php } else { ?>
                                                <tr class="bg-transparent">
                                                    <td colspan="7" class="text-right text-light border-top-0">Total Test Amount</td>
                                                    <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_test_amount, 2); ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } else { ?>
                                            <tr class="text-center">
                                                <td colspan="9"><?php echo $this->lang->line('no_data_found'); ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="border-bottom border-1">
                                        <?php if ($type == 'test' && $commission == 1) { ?>
                                            <tr>
                                                <th colspan="8" class="text-right font-weight-600">Total Amount</th>
                                                <th colspan="2" class="text-right font-weight-600"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format(($total_opd_amount + $total_ipd_amount + $total_test_amount), 2); ?></th>
                                            </tr>
                                        <?php } else { ?>
                                            <tr>
                                                <th colspan="7" class="text-right font-weight-600">Total Amount</th>
                                                <th colspan="2" class="text-right font-weight-600"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format(($total_opd_amount + $total_ipd_amount + $total_test_amount), 2); ?></th>
                                            </tr>
                                        <?php }  ?>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('frontoffice/appointment/get_single_appointment'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>