<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('billing'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(VIEW, 'report', 'opd')) { ?>
                <a href="<?php echo site_url('report/opd'); ?>" class="btn btn-primary btn-sm mr-15"><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'report', 'appointment')) { ?>
                <a href="<?php echo site_url('report/appointment'); ?>" class="btn btn-success btn-sm mr-15"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php if (has_permission(VIEW, 'report', 'billing')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-primary">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-money"></i>
                        <?php echo $this->lang->line('collection'); ?> <?php echo $this->lang->line('bill'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/billing/collection'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('collection'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(ADD, 'report', 'billing')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-space">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-exchange"></i>
                        <?php echo $this->lang->line('due'); ?> <?php echo $this->lang->line('bill'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/billing/due'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('due'); ?> <?php echo $this->lang->line('collection'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(ADD, 'report', 'billing')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-streaks">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-undo"></i>
                        <?php echo $this->lang->line('rejected'); ?> <?php echo $this->lang->line('bill'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/billing/rejected'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('rejected'); ?> <?php echo $this->lang->line('bill'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(ADD, 'report', 'billing')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-bunting">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-money"></i>
                        <?php echo $this->lang->line('income'); ?> <?php echo $this->lang->line('bill'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/billing/income'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('income'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(ADD, 'report', 'billing')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-paradise">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-list-alt"></i>
                        <?php echo $this->lang->line('collection'); ?> <?php echo $this->lang->line('summary'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/billing/summary'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('summary'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(ADD, 'report', 'billing')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-dusk">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-tasks"></i>
                        <?php echo $this->lang->line('collection'); ?> <?php echo $this->lang->line('statement'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/billing/statement'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('statement'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(ADD, 'report', 'billing')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-warbler">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-balance-scale"></i>
                        <?php echo $this->lang->line('sales'); ?> <?php echo $this->lang->line('statement'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/billing/sales'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('sales'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(ADD, 'report', 'billing')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-heaven">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-flask"></i>
                        <?php echo $this->lang->line('test'); ?> <?php echo $this->lang->line('summary'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/billing/test'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('test'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>
        
        <?php if (has_permission(ADD, 'report', 'billing')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-pony">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-user"></i>
                        <?php echo $this->lang->line('authorized'); ?> <?php echo $this->lang->line('bill'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/billing/authorized'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('authorized'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>
        
        <?php if (has_permission(VIEW, 'report', 'billing')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-primary">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-user"></i>
                        <?php echo $this->lang->line('daily'); ?> <?php echo $this->lang->line('income'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/billing/daily'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('income'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->