<!DOCTYPE html>
<html>

<head>
    <title>Holiday</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">
                HOLIDAY REPORT<br>
                <small>Date: <?php echo date('M d, Y', strtotime($form_date)); ?> - <?php echo date('M d, Y', strtotime($to_date)); ?></small>
            </h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%" align="left">
                                <?php if (isset($created_by) && !empty($created_by)) { ?>
                                    <b>Created By:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $employee->name; ?>, <?php echo $employee->phone; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Holiday:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="30%" align="right">
                                <b>Print Date:</b>
                                <span style="font-size: 12px;"><?php echo date('M d, Y h:ia'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                            <th><?php echo $this->lang->line('title'); ?></th>
                            <th><?php echo $this->lang->line('from_date'); ?></th>
                            <th><?php echo $this->lang->line('to_date'); ?></th>
                            <th><?php echo $this->lang->line('remark'); ?></th>
                            <th><?php echo $this->lang->line('status'); ?></th>
                            <th><?php echo $this->lang->line('created'); ?></th>
                            <th><?php echo $this->lang->line('created_by'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        if (isset($holidays) && !empty($holidays)) { ?>
                            <?php foreach ($holidays as $obj) { ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?php echo $obj->title; ?></td>
                                    <td><?php echo $obj->from_date ? date('M d, Y', strtotime($obj->from_date)) : ''; ?></td>
                                    <td><?php echo $obj->to_date ? date('M d, Y', strtotime($obj->to_date)) : ''; ?></td>
                                    <td><?php echo word_limiter($obj->remark, 3); ?></td>
                                    <td><?php echo $obj->status ? '<span class="badge badge-success">' . $this->lang->line('active') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('in_active') . '</span>'; ?></td>
                                    <td><?php echo $obj->created_at ? date('M d, Y', strtotime($obj->created_at)) : ''; ?></td>
                                    <td><?php echo $obj->created_by ? $obj->created_by : ''; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>