<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(VIEW, 'report', 'opd')) { ?>
                <a href="<?php echo site_url('report/opd'); ?>" class="btn btn-primary btn-sm mr-15"><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'report', 'appointment')) { ?>
                <a href="<?php echo site_url('report/appointment'); ?>" class="btn btn-success btn-sm mr-15"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php if (has_permission(VIEW, 'report', 'attendance')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-primary">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-clock-o"></i>
                        <?php echo $this->lang->line('daily'); ?> <?php echo $this->lang->line('attendance'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/attendance/daily'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('daily'); ?> <?php echo $this->lang->line('attendance'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'report', 'attendance')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-primary">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-clock-o"></i>
                        Not In Office <?php echo $this->lang->line('attendance'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/attendance/not_in_office'); ?>" class="btn btn-danger">
                            <?php echo $this->lang->line('daily'); ?> <?php echo $this->lang->line('attendance'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'report', 'attendance')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-streaks">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-calendar"></i>
                        <?php echo $this->lang->line('monthly'); ?> <?php echo $this->lang->line('attendance'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/attendance/monthly'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('monthly'); ?> <?php echo $this->lang->line('attendance'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'report', 'attendance')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-paradise">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-list-alt"></i>
                        <?php echo $this->lang->line('yearly'); ?> <?php echo $this->lang->line('attendance'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/attendance/yearly'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('yearly'); ?> <?php echo $this->lang->line('attendance'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'report', 'attendance')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-space">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-calendar-o"></i>
                        <?php echo $this->lang->line('monthly'); ?> <?php echo $this->lang->line('late'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/attendance/late'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('monthly'); ?> <?php echo $this->lang->line('late'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'report', 'attendance')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-heaven">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-times"></i>
                        <?php echo $this->lang->line('early_leaving'); ?> <?php echo $this->lang->line('report'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/attendance/early_leaving'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('early_leaving'); ?> <?php echo $this->lang->line('report'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'report', 'attendance')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-bunting">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-bar-chart"></i>
                        <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('summary'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/attendance/summary'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('summary'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'report', 'attendance')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-pony">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-leaf"></i>
                        <?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('report'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/attendance/leave'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('report'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>


        <?php if (has_permission(VIEW, 'report', 'attendance')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-warbler">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-gift"></i>
                        <?php echo $this->lang->line('holiday'); ?> <?php echo $this->lang->line('report'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/attendance/holiday'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('holiday'); ?> <?php echo $this->lang->line('report'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->