<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Sms.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Sms
 * @description     : Manage apointment report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Sms extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Sms_Model', 'sms', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Sms Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $role_id = $this->input->get('role_id');
            $operator = $this->input->get('operator');
            $created_by = $this->input->get('created_by');

            $this->data['text_messages'] = $this->sms->get_sms_list($keyword, $type, $form_date, $to_date, $role_id, $operator, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['role_id'] = $role_id;
            $this->data['operator'] = $operator;
            $this->data['created_by'] = $created_by;
        }
        $this->data['roles'] = $this->sms->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['employees'] = $this->sms->get_employee_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('sms') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/sms/index', $this->data);
    }

    public function pdf() {

        if ($_GET && $this->input->get('date')) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $role_id = $this->input->get('role_id');
            $operator = $this->input->get('operator');
            $created_by = $this->input->get('created_by');

            $this->data['text_messages'] = $this->sms->get_sms_list($keyword, $type, $form_date, $to_date, $role_id, $operator, $created_by);
            $this->data['role'] = $this->sms->get_single('roles', array('id' => $role_id));
            
            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/sms/pdf', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('sms_' . rand() . '.pdf', 'I');
        }
    }
    /*     * ***************Function get_single_sms**********************************
     * @type            : Function
     * @function name   : get_single_sms
     * @description     : "Load single sms information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_sms() {
        $id = $this->input->post('id');
        $this->data['sms'] = $this->sms->get_single_sms($id);
        echo $this->load->view('sms/view', $this->data);
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "SMS" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('report/sms');
        }

        $sms = $this->sms->get_single('text_message_logs', array('id' => $id));
        if (!empty($sms)) {
            // delete sms data
            $this->sms->delete('text_message_logs', array('id' => $id));
            create_log('Has been deleted a text message logs : ' . $sms->sms_text);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
