<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Income.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Income
 * @description     : Manage income report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Income extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Income_Model', 'income', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Income Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $income_head_id = $this->input->get('income_head_id');
            $payment_method = $this->input->get('payment_method');
            $created_by = $this->input->get('created_by');

            $this->data['incomes'] = $this->income->get_income_list($keyword, $form_date, $to_date, $income_head_id, $payment_method, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['income_head_id'] = $income_head_id;
            $this->data['payment_method'] = $payment_method;
            $this->data['created_by'] = $created_by;
        }

        $this->data['income_heads'] = $this->income->get_list('income_heads', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['employees'] = $this->income->get_employee_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('income') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/income/index', $this->data);
    }

    public function pdf() {
        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $income_head_id = $this->input->get('income_head_id');
            $payment_method = $this->input->get('payment_method');
            $created_by = $this->input->get('created_by');

            $this->data['incomes'] = $this->income->get_income_list($keyword, $form_date, $to_date, $income_head_id, $payment_method, $created_by);
            $this->data['form_date'] = $form_date;
            $this->data['income_head'] =  $this->income->get_single('income_heads', array('id' => $income_head_id));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/income/pdf', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('income_' . rand() . '.pdf', 'D');
        }
    }
}
