<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Expenditure.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Expenditure
 * @description     : Manage expenditure report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Expenditure extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Expenditure_Model', 'expenditure', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Expenditure Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $expenditure_head_id = $this->input->get('expenditure_head_id');
            $payment_method = $this->input->get('payment_method');
            $created_by = $this->input->get('created_by');

            $this->data['expenditures'] = $this->expenditure->get_expenditure_list($keyword, $form_date, $to_date, $expenditure_head_id, $payment_method, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['expenditure_head_id'] = $expenditure_head_id;
            $this->data['payment_method'] = $payment_method;
            $this->data['created_by'] = $created_by;
        }

        $this->data['expheads'] = $this->expenditure->get_list('expenditure_heads', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['employees'] = $this->expenditure->get_employee_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('expenditure') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/expenditure/index', $this->data);
    }

    public function pdf() {
        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $expenditure_head_id = $this->input->get('expenditure_head_id');
            $payment_method = $this->input->get('payment_method');
            $created_by = $this->input->get('created_by');

            $this->data['expenditures'] = $this->expenditure->get_expenditure_list($keyword, $form_date, $to_date, $expenditure_head_id, $payment_method, $created_by);
            $this->data['form_date'] = $form_date;
            $this->data['expenditure_head'] =  $this->expenditure->get_single('expenditure_heads', array('id' => $expenditure_head_id));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/expenditure/pdf', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('expenditure_' . rand() . '.pdf', 'D');
        }
    }
}
