<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('purchase'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_purchase'); ?>
        </h4>
        <div class="align-items-center">
            <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                <a href="<?php echo site_url('pharmacy/refund'); ?>" class="btn btn-xs btn-info">
                    <i class="fa fa-undo font-12 mr-5"></i>
                    <?php echo $this->lang->line('refund'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'stock')) { ?>
                <a href="<?php echo site_url('pharmacy/stock'); ?>" class="btn btn-xs btn-success">
                    <i class="fa fa-bar-chart font-12 mr-5"></i>
                    <?php echo $this->lang->line('stock'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'sale')) { ?>
                <a href="<?php echo site_url('pharmacy/sale'); ?>" class="btn btn-xs btn-danger">
                    <i class="fa fa-balance-scale font-12 mr-5"></i>
                    <?php echo $this->lang->line('sale'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('pharmacy/purchase'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="payment_type"><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="payment_type" id="payment_type">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <option value="cash" <?php echo isset($payment_type) && $payment_type == 'cash' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('cash'); ?></option>
                                <option value="credit" <?php echo isset($payment_type) && $payment_type == 'credit' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('credit'); ?></option>
                                <option value="due" <?php echo isset($payment_type) && $payment_type == 'due' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('due'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="manufacturer_id"><?php echo $this->lang->line('manufacturer'); ?></label>
                            <select class="form-control custom-select select2" name="manufacturer_id" id="manufacturer_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('manufacturer'); ?></option>
                                <?php foreach ($manufacturers as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($manufacturer_id) && $manufacturer_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'pharmacy', 'purchase')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-industry font-30 mr-10"></i>
                            <?php echo $this->lang->line('purchase'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php if (has_permission(ADD, 'pharmacy', 'purchase')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('pharmacy/purchase/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('purchase'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0" id="mainTable">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                        <th><?php echo $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('manufacturer'); ?></th>
                                        <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('bill'); ?></th>
                                        <th><?php echo $this->lang->line('discount'); ?></th>
                                        <th><?php echo $this->lang->line('net_payable'); ?></th>
                                        <th><?php echo $this->lang->line('advanced'); ?></th>
                                        <th><?php echo $this->lang->line('due'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th width="15%"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody id="bodyTable">
                                    <?php if (isset($purchases) && !empty($purchases)) { ?>
                                        <?php foreach ($purchases as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->custom_invoice_id; ?></td>
                                                <td><?php echo date('d M, Y h:ia', strtotime($obj->purchase_date)); ?></td>
                                                <td><?php echo $obj->manufacturer; ?></td>
                                                <td><?php echo $obj->total_bill; ?></td>
                                                <td><?php echo $obj->discount; ?></td>
                                                <td><?php echo $obj->net_payable; ?></td>
                                                <td><?php echo $obj->advanced; ?></td>
                                                <td><?php echo $obj->due_amount; ?></td>
                                                <td>
                                                    <?php if ($obj->payment_status == 'complete') { ?>
                                                        <span class="badge badge-success"><?php echo $this->lang->line('complete'); ?></span>
                                                    <?php } elseif ($obj->payment_status == 'rejected') { ?>
                                                        <span class="badge badge-danger"><?php echo $this->lang->line('rejected'); ?></span>
                                                    <?php } else { ?>
                                                        <span class="badge badge-warning"><?php echo $this->lang->line('cancel'); ?></span>
                                                    <?php } ?>
                                                </td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'pharmacy', 'purchase')) { ?>
                                                        <a href="<?php echo site_url('pharmacy/purchase/invoice/' . $obj->id); ?>" class="btn btn-xs btn-primary"><i class="fa fa-eye"></i> <?php echo $this->lang->line('invoice'); ?></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(EDIT, 'pharmacy', 'purchase')) { ?>
                                                        <button type="button" onclick="getInvoiceId('<?php echo $obj->id; ?>')" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#paymentStatusModal">
                                                            <i class="fa fa-pause"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(EDIT, 'pharmacy', 'purchase')) { ?>
                                                        <a class="btn btn-xs btn-success" href="<?php echo site_url('pharmacy/purchase/edit/' . $obj->id); ?>"><i class="fa fa-pencil-square-o"></i></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'pharmacy', 'purchase')) { ?>
                                                        <a class="btn btn-xs btn-danger round" href="<?php echo site_url('pharmacy/purchase/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i> </a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="11"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Payment Status Modal -->
<div class="modal fade" id="paymentStatusModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('status'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="paymentStatusForm" method="POST" action="<?php echo base_url('pharmacy/purchase/payment_status'); ?>">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="payment_status"><?php echo $this->lang->line('status'); ?></label>
                        <select class="form-control" name="payment_status" id="payment_status" required>
                            <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                            <option value="complete"><?php echo $this->lang->line('complete'); ?></option>
                            <option value="rejected"><?php echo $this->lang->line('rejected'); ?></option>
                            <option value="canceled"><?php echo $this->lang->line('cancel'); ?></option>
                        </select>
                    </div>
                    <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                            </div>
                            <textarea class="form-control" name="note" id="note" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <input type="hidden" id="invoice_id" name="invoice_id">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                    <button id="submit" type="submit" class="btn btn-primary"><?php echo $this->lang->line('submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
    function getInvoiceId(id) {
        $.ajax({
            url: '<?php echo site_url('pharmacy/purchase/getInvoiceId/') ?>' + id,
            dataType: 'json',
            success: function(data) {
                $('#invoice_id').val(data.id);
                $('#payment_status').val(data.payment_status);
                $('#note').val(data.note);
            }
        });
    }
</script>

<script type="text/javascript">
    $(document).ready(function(e) {
        $("#paymentStatusForm").on('submit', (function(e) {
            e.preventDefault();
            $.ajax({
                url: '<?php echo base_url('pharmacy/purchase/payment_status'); ?>',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.status == "failed") {
                        var message = "";
                        $.each(data.error, function(index, value) {
                            message += value;
                        });
                        $.toast({
                            text: message,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-danger',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });

                    } else {
                        $.toast({
                            text: data.message,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-primary',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });
                        // location.reload(true);
                        $("#mainTable").load(window.location.href + " #bodyTable");
                        $('#paymentStatusModal').modal('hide');
                    }
                    $('#paymentStatusForm').find('form')[0].reset();
                }
            });
        }));
    });
</script>


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>