<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Medicine_Model extends MY_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_medicine_category_list($limit, $offset, $search, $count)
    {
        $this->db->select('MC.*');
        $this->db->from('medicine_categories AS MC');
        if ($search) {
            $this->db->like('MC.name', $search, 'both');
            $this->db->or_like('MC.note', $search, 'both');
        }
        $this->db->order_by('MC.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_category_name($name, $id = null)
    {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('medicine_categories')->num_rows();
    }

    public function get_medicine_type_list($limit, $offset, $search, $count)
    {
        $this->db->select('MT.*');
        $this->db->from('medicine_types AS MT');
        if ($search) {
            $this->db->like('MT.name', $search, 'both');
            $this->db->or_like('MT.note', $search, 'both');
        }
        $this->db->order_by('MT.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_type_name($name, $id = null)
    {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('medicine_types')->num_rows();
    }


    public function get_medicine_generic_list($limit, $offset, $search, $count)
    {
        $this->db->select('MG.*, MT.name as type');
        $this->db->from('medicine_generics AS MG');
        $this->db->join('medicine_types AS MT', 'MT.id = MG.id', 'left');
        if ($search) {
            $this->db->like('MG.name', $search, 'both');
            $this->db->or_like('MG.note', $search, 'both');
        }
        $this->db->order_by('MG.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_generic_name($name, $id = null)
    {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('medicine_generics')->num_rows();
    }


    public function get_medicine_dosage_list($limit, $offset, $category_id, $search, $count)
    {
        $this->db->select('MD.*, MC.name as category');
        $this->db->from('medicine_dosages AS MD');
        $this->db->join('medicine_categories AS MC', 'MC.id = MD.category_id', 'left');
        if ($category_id) {
            $this->db->where('MD.category_id', $category_id);
        }
        if ($search) {
            $this->db->like('MD.name', $search, 'both');
            $this->db->or_like('MD.note', $search, 'both');
        }
        $this->db->order_by('MD.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_dosage_name($name, $id = null)
    {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('medicine_dosages')->num_rows();
    }

    public function get_medicine_unit_list($limit, $offset, $search, $count)
    {
        $this->db->select('MU.*');
        $this->db->from('medicine_units AS MU');
        if ($search) {
            $this->db->like('MU.name', $search, 'both');
            $this->db->or_like('MU.note', $search, 'both');
        }
        $this->db->order_by('MU.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_unit_name($name, $id = null)
    {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('medicine_units')->num_rows();
    }

    public function get_medicine_list($limit, $offset, $keyword, $type_id, $category_id, $manufacturer_id, $generic_id, $unit_id, $count)
    {
        $this->db->select('M.*, MC.name as category, MF.name as manufacturer');
        $this->db->from('medicines AS M');
        $this->db->join('medicine_categories AS MC', 'MC.id = M.category_id', 'left');
        $this->db->join('manufacturers AS MF', 'MF.id = M.manufacturer_id', 'left');
        $this->db->join('medicine_types AS MT', 'MT.id = M.type_id', 'left');
        $this->db->join('medicine_generics AS MG', 'MG.id = M.generic_id', 'left');
        $this->db->join('medicine_units AS MU', 'MU.id = M.unit_id', 'left');
        if ($keyword) {
            $this->db->like('M.code', $keyword);
            $this->db->or_like('M.medicine_name', $keyword, 'both');
            $this->db->or_like('M.mrp', $keyword, 'both');
            $this->db->or_like('MC.name', $keyword, 'both');
            $this->db->or_like('MF.name', $keyword, 'both');
            $this->db->or_like('MT.name', $keyword, 'both');
            $this->db->or_like('MG.name', $keyword, 'both');
            $this->db->or_like('MU.name', $keyword, 'both');
        }
        if ($type_id) {
            $this->db->where('M.type_id', $type_id);
        }
        if ($category_id) {
            $this->db->where('M.category_id', $category_id);
        }
        if ($manufacturer_id) {
            $this->db->where('M.manufacturer_id', $manufacturer_id);
        }
        if ($generic_id) {
            $this->db->where('M.generic_id', $generic_id);
        }
        if ($unit_id) {
            $this->db->where('M.unit_id', $unit_id);
        }
        $this->db->order_by('M.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_medicine_name($name, $id = null)
    {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('medicine_name', $name);
        return $this->db->get('medicines')->num_rows();
    }

    function get_single_medicine($id)
    {
        $this->db->select('M.*, MT.name as type, MC.name as category, MF.name as manufacturer, MG.name as generic, MU.name as unit, C.name as created_by, E.name as modified_by');
        $this->db->from('medicines AS M');
        $this->db->join('medicine_categories AS MC', 'MC.id = M.category_id', 'left');
        $this->db->join('manufacturers AS MF', 'MF.id = M.manufacturer_id', 'left');
        $this->db->join('medicine_types AS MT', 'MT.id = M.type_id', 'left');
        $this->db->join('medicine_generics AS MG', 'MG.id = M.generic_id', 'left');
        $this->db->join('medicine_units AS MU', 'MU.id = M.unit_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = M.created_by', 'left');
        $this->db->join('employees AS E', 'E.user_id = M.modified_by', 'left');
        $this->db->where('M.id', $id);
        return $this->db->get()->row();
    }

    public function get_medicine_price_update_list($category_id, $manufacturer_id, $generic_id)
    {
        $this->db->select('M.*, MC.name as category, MF.name as manufacturer');
        $this->db->from('medicines AS M');
        $this->db->join('medicine_categories AS MC', 'MC.id = M.category_id', 'left');
        $this->db->join('manufacturers AS MF', 'MF.id = M.manufacturer_id', 'left');
        $this->db->join('medicine_generics AS MG', 'MG.id = M.generic_id', 'left');
        if ($category_id) {
            $this->db->where('M.category_id', $category_id);
        }
        if ($manufacturer_id) {
            $this->db->where('M.manufacturer_id', $manufacturer_id);
        }
        if ($generic_id) {
            $this->db->where('M.generic_id', $generic_id);
        }
        $this->db->order_by('M.id', 'DESC');
        return $this->db->get()->result();
    }
}
