<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Dashboard.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Dashboard
 * @description     : Manage dashboard.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Dashboard extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Pharmacy_Model', 'pharmacy', true);
        $this->load->model('Dashboard_Model', 'dashboard', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Dashboard List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $this->data['total_admin'] = $this->dashboard->get_total_admin();
        $this->data['total_doctor'] = $this->dashboard->get_total_doctor();
        $this->data['total_patient'] = $this->dashboard->get_total_patient();
        $this->data['total_accountant'] = $this->dashboard->get_total_accountant();
        $this->data['total_pathologist'] = $this->dashboard->get_total_pathologist();
        $this->data['total_radiologist'] = $this->dashboard->get_total_radiologist();
        $this->data['total_nurse'] = $this->dashboard->get_total_nurse();
        $this->data['total_receptionist'] = $this->dashboard->get_total_receptionist();


        // pharmacy
        $this->data['total_customer'] = $this->pharmacy->get_total_customer();
        $this->data['total_manufacturer'] = $this->pharmacy->get_total_manufacturer();
        $this->data['total_medicine'] = $this->pharmacy->get_total_medicine();
        $this->data['total_medicine_purchase'] = $this->pharmacy->get_total_medicine_purchase();
        $this->data['total_medicine_sale'] = $this->pharmacy->get_total_medicine_sale();
        $this->data['total_medicine_refund'] = $this->pharmacy->get_total_medicine_refund();
        $this->data['total_medicine_expire'] = $this->pharmacy->get_total_medicine_expire();
        $this->data['total_medicine_invoice'] = $this->pharmacy->get_total_medicine_invoice();
        $this->data['total_sale'] = $this->pharmacy->get_total_sale();
        $this->data['total_purchase'] = $this->pharmacy->get_total_purchase();

        $this->data['invoices'] = $this->pharmacy->get_invoice_list();

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('pharmacy') . ' ' . $this->lang->line('dashboard') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('pharmacy/dashboard', $this->data);
    }
}
