<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('patient'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_patient'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'patient', 'patient')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user-circle-o font-30 mr-10"></i>
                            <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php echo form_open_multipart(site_url('patient'), array('name' => 'search', 'id' => 'search', 'class' => 'form-inline needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group mr-10">
                        <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>" autocomplete="off">
                    </div>
                    <div class="form-group mr-10">
                        <select class="form-control custom-select" name="card_issue" id="card_issue">
                            <option value="" selected>Select Card Issue</option>
                            <option value="yes" <?php echo isset($card_issue) && $card_issue == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                            <option value="no" <?php echo isset($card_issue) && $card_issue == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-primary ml-10 float-right" type="submit"><?php echo $this->lang->line('search'); ?></button>
                    </div>
                    <?php echo form_close(); ?>

                    <?php if (has_permission(ADD, 'patient', 'patient')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('patient/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('patient'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('photo'); ?></th>
                                        <th><?php echo $this->lang->line('patient_id'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('gender'); ?></th>
                                        <th><?php echo $this->lang->line('phone'); ?></th>
                                        <th><?php echo $this->lang->line('address'); ?></th>
                                        <th>Card Issue</th>
                                        <th class="w-15"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($patients) && !empty($patients)) { ?>
                                        <?php foreach ($patients as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td>
                                                    <div class="avatar avatar-sm">
                                                        <?php if ($obj->photo) { ?>
                                                            <img src="<?php echo UPLOAD_PATH; ?>patient-photo/<?php echo $obj->photo; ?>" alt="user" class="avatar-img rounded-circle">
                                                        <?php } elseif ($obj->gender == 'male') { ?>
                                                            <img src="<?php echo IMG_URL; ?>male.png" alt="male" class="avatar-img rounded-circle">
                                                        <?php } else { ?>
                                                            <img src="<?php echo IMG_URL; ?>female.png" alt="female" class="avatar-img rounded-circle">
                                                        <?php }  ?>
                                                    </div>
                                                </td>
                                                <td><?php echo $obj->patient_unique_id; ?></td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td><?php echo $this->lang->line($obj->gender); ?></td>
                                                <td><?php echo $obj->phone; ?></td>
                                                <td><?php echo $obj->address; ?></td>
                                                <td><?php echo $obj->card_issue_date ? date('d F, Y', strtotime($obj->card_issue_date)) : ''; ?></td>
                                                <td>
                                                    <?php if ($obj->card_issue_date) { ?>
                                                        <?php if (has_permission(VIEW, 'patient', 'patient')) { ?>
                                                            <a class="btn btn-xs btn-success mr-5" target="_blank" href="<?php echo site_url('patient/download/' . $obj->user_id); ?>"><i class="fa fa-download"></i></a>
                                                        <?php } ?>
                                                    <?php } else { ?>
                                                        <?php if (has_permission(ADD, 'patient', 'patient')) { ?>
                                                            <button class="btn btn-xs btn-primary mr-5" type="button" onclick="generateCard(<?php echo $obj->user_id; ?>);"><i class="fa fa-id-card"></i></button>
                                                        <?php } ?>
                                                    <?php } ?>
                                                    <?php if (has_permission(VIEW, 'patient', 'patient')) { ?>
                                                        <button class="btn btn-xs btn-info mr-5" type="button" onclick="get_view_modal(<?php echo $obj->user_id; ?>);" data-toggle="modal" data-target=".viewModalCenter"><i class="fa fa-eye"></i></button>
                                                    <?php } ?>
                                                    <?php if (has_permission(EDIT, 'patient', 'patient')) { ?>
                                                        <a class="btn btn-xs btn-success mr-5" href="<?php echo site_url('patient/edit/' . $obj->user_id); ?>"><i class="fa fa-pencil-square-o"></i></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'patient', 'patient')) { ?>
                                                        <a class="btn btn-danger btn-xs" href="<?php echo site_url('patient/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash"></i> </a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="9"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

<script type="text/javascript">
    function get_view_modal(user_id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('patient/get_single_patient'); ?>",
            data: {
                user_id: user_id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }

    function generateCard(user_id) {
        $.confirm({
            title: 'Patient Card',
            content: 'Are you sure to generate card?',
            type: 'red',
            typeAnimated: true,
            buttons: {
                tryAgain: {
                    text: 'Yes',
                    btnClass: 'btn-red',
                    action: function() {
                        $.ajax({
                            type: "POST",
                            url: "<?php echo site_url('patient/generate_card'); ?>",
                            data: {
                                user_id: user_id
                            },
                            success: function(response) {
                                location.reload(true);
                            }
                        });
                        $.alert('Card generate successfully!');
                    }
                },
                close: function() {}
            }
        });
    }
</script>