<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('opd_patient'); ?> <?php echo $this->lang->line('profile'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('opd_patient'); ?> <?php echo $this->lang->line('profile'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('opd/profile-left'); ?>
        <!-- col-xl-9 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'opd', 'opd')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-caret-square-o-down font-30 mr-10"></i>
                            <?php echo $this->lang->line('visit'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                    <?php echo form_open_multipart(site_url('opd/profile/' . $profile->user_id), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation form-inline', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>">
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th style="width: 15%;"><?php echo $this->lang->line('bill_no'); ?></th>
                                        <th><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('doctor'); ?></th>
                                        <th><?php echo $this->lang->line('reference'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th width="18%"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($opd_details) && !empty($opd_details)) { ?>
                                        <?php foreach ($opd_details as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->custom_invoice_id; ?></td>
                                                <td><?php echo date('d M, Y', strtotime($obj->appointment_date)); ?></td>
                                                <td><?php echo $obj->doctor; ?></td>
                                                <td><?php echo $obj->reference; ?></td>
                                                <td>
                                                    <?php
                                                    if ($obj->payment_status == 'rejected') {
                                                        echo '<span class="badge badge-danger">' . $this->lang->line('rejected') . '</span>';
                                                    } elseif ($obj->payment_status == 'canceled') {
                                                        echo '<span class="badge badge-warning">' . $this->lang->line('cancel') . '</span>';
                                                    } elseif ($obj->payment_status == 'pending') {
                                                        echo '<span class="badge badge-info">' . $this->lang->line('pending') . '</span>';
                                                    } else {
                                                        echo '<span class="badge badge-success">' . $this->lang->line('complete') . '</span>';
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'opd', 'opd')) { ?>
                                                        <button class="btn btn-orange btn-xs" type="button" onclick="printVisitBill(<?php echo $obj->patient_id; ?>, <?php echo $obj->id; ?>);">
                                                            <i class="fa fa-print"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(VIEW, 'opd', 'opd')) { ?>
                                                        <button class="btn btn-info btn-xs" type="button" onclick="get_view_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter"><i class="fa fa-eye"></i></button>
                                                    <?php } ?>
                                                    <?php if (has_permission(EDIT, 'opd', 'opd')) { ?>
                                                        <button class="btn btn-success btn-xs" onclick="getOpdVisitData('<?php echo $obj->id; ?>')" type="button" data-toggle="modal" data-target="#editOpdVisitModal">
                                                            <i class="fa fa-pencil"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'opd', 'opd')) { ?>
                                                        <a class="btn btn-danger btn-xs" href="<?php echo site_url('opd/opd_visit_delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash"></i></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="7"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->



<?php if (has_permission(EDIT, 'opd', 'opd')) { ?>
    <!-- Edit OPD Visit Modal -->
    <div class="modal fade" id="editOpdVisitModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content modal-media-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $this->lang->line('edit') . " " . $this->lang->line('visit'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <?php echo form_open_multipart(site_url('opd/editVisit'), array('name' => 'editVisitForm', 'id' => 'editVisitForm', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-7">
                            <!-- Patient Data Start -->
                            <ul class="list-group list-group-flush mb-20">
                                <li class="list-group-item bg-light"><b><?php echo $this->lang->line('name'); ?>:</b><span class="ml-5 text-dark"><?php echo $profile->name; ?></span></li>
                                <li class="list-group-item bg-light"><b><?php echo $this->lang->line('patient_id'); ?>:</b><span class="ml-5 text-dark"><?php echo $profile->patient_unique_id; ?></span></li>
                                <li class="list-group-item bg-light"><b><?php echo $this->lang->line('phone'); ?>:</b><span class="ml-5 text-dark"><?php echo $profile->phone; ?></span></li>
                            </ul>
                            <!-- Patient Data End -->

                            <!-- Patient Information End -->
                            <div class="form-row">
                                <div class="col-md-2 mb-10">
                                    <label for="height"><?php echo $this->lang->line('height'); ?></label>
                                    <input type="text" class="form-control form-control-sm" name="height" id="edit_height" value="<?php echo isset($height) ?  $height : ''; ?>" placeholder="<?php echo $this->lang->line('height'); ?>">
                                </div>
                                <div class="col-md-2 mb-10">
                                    <label for="weight"><?php echo $this->lang->line('weight'); ?></label>
                                    <input type="text" class="form-control form-control-sm" name="weight" id="edit_weight" value="<?php echo isset($weight) ?  $weight : ''; ?>" placeholder="<?php echo $this->lang->line('weight'); ?>">
                                </div>
                                <div class="col-md-3 mb-10">
                                    <label for="bp"><?php echo $this->lang->line('bp'); ?></label>
                                    <input type="text" class="form-control form-control-sm" name="bp" id="edit_bp" value="<?php echo isset($bp) ?  $bp : ''; ?>" placeholder="<?php echo $this->lang->line('bp'); ?>">
                                </div>
                                <div class="col-md-5 mb-10">
                                    <label for="symptoms"><?php echo $this->lang->line('symptoms'); ?></label>
                                    <input type="text" class="form-control form-control-sm" name="symptoms" id="edit_symptoms" value="<?php echo isset($symptoms) ?  $symptoms : ''; ?>" placeholder="<?php echo $this->lang->line('symptoms'); ?>">
                                </div>
                                <div class="col-md-12 mt-10 mb-10">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><?php echo $this->lang->line('case'); ?></span>
                                        </div>
                                        <textarea class="form-control form-control-sm" name="case" id="edit_case" aria-label="<?php echo $this->lang->line('case'); ?>"><?php echo isset($case) ?  $case : ''; ?></textarea>
                                    </div>
                                </div>
                                <div class="col-md-12 mt-10 mb-10">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                                        </div>
                                        <textarea class="form-control form-control-sm" name="note" id="edit_note" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-row bg-light pl-5 pr-5">
                                <div class="col-md-12 mb-10">
                                    <label for="appointment_date"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('date'); ?></label>
                                    <input type="text" disabled="true" class="form-control form-control-sm" name="appointment_date" id="edit_appointment_date" value="<?php echo isset($appointment_date) ?  $appointment_date : ''; ?>" placeholder="<?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('date'); ?>" required>
                                </div>
                                <div class="col-md-12 mb-10">
                                    <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?></label>
                                    <select disabled class="form-control app_doctor_id select2" name="doctor_id" id="edit_doctor_id" required>
                                        <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                        <?php foreach ($doctors as $obj) { ?>
                                            <option value="<?php echo $obj->user_id; ?>"><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-10">
                                    <label for="casualty"><?php echo $this->lang->line('casualty'); ?></label>
                                    <select class="form-control form-control-sm custom-select" name="casualty" id="edit_casualty">
                                        <option value="0" <?php echo isset($casualty) && $casualty == 0 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('no'); ?></option>
                                        <option value="1" <?php echo isset($casualty) && $casualty == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('yes'); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-10">
                                    <label for="old_patient"><?php echo $this->lang->line('patient'); ?></label>
                                    <select readonly="readonly" class="form-control form-control-sm" name="old_patient" id="edit_old_patient" required="" onchange="get_doctor_charge(this.value)">
                                        <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                        <option value="0" <?php echo isset($old_patient) && $old_patient == 0 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('first_time'); ?></option>
                                        <option value="1" <?php echo isset($old_patient) && $old_patient == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('second_time'); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-10">
                                    <label for="doctor_charge"><?php echo $this->lang->line('charge'); ?></label>
                                    <input type="number" disabled class="form-control form-control-sm" name="doctor_charge" id="edit_doctor_charge" value="<?php echo isset($doctor_charge) ?  $doctor_charge : ''; ?>" placeholder="<?php echo $this->lang->line('doctor'); ?> <?php echo $this->lang->line('charge'); ?>">
                                </div>
                                <div class="col-md-6 mb-10">
                                    <label for="discount"><?php echo $this->lang->line('discount'); ?></label>
                                    <input type="number" class="form-control form-control-sm" name="discount" id="edit_discount" value="<?php echo isset($discount) ?  $discount : ''; ?>" placeholder="<?php echo $this->lang->line('discount'); ?>">
                                </div>
                                <input type="hidden" name="hospital_commission" id="edit_hospital_commission" value="0">
                                <div class="col-md-12 mb-10">
                                    <label for="reference_id"><?php echo $this->lang->line('reference'); ?></label>
                                    <select class="form-control app_reference_id select2" name="reference_id" id="edit_reference_id">
                                        <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('reference'); ?></option>
                                        <?php foreach ($references as $obj) { ?>
                                            <option value="<?php echo $obj->user_id; ?>"><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-md-12 mb-10">
                                    <label for="payment_status"><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('status'); ?></label>
                                    <select class="form-control form-control-sm custom-select" name="payment_status" id="edit_payment_status">
                                        <option value="complete" <?php echo isset($payment_status) && $payment_status == 'complete' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('complete'); ?></option>
                                        <option value="rejected" <?php echo isset($payment_status) && $payment_status == 'rejected' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('rejected'); ?></option>
                                        <option value="canceled" <?php echo isset($payment_status) && $payment_status == 'canceled' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('cancel'); ?></option>
                                        <option value="pending" <?php echo isset($payment_status) && $payment_status == 'pending' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('pending'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <input type="hidden" id="edit_patient_id" name="patient_id">
                    <input type="hidden" id="edit_id" name="id">
                    <input type="hidden" id="is_limit" value="0">
                    <input type="hidden" id="discount_limit" value="0">
                    <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                    <button type="submit" id="editVisitSubmit" class="btn btn-gradient-primary"><?php echo $this->lang->line('update'); ?></button>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>


    <script>
        $("#edit_doctor_id").on("change", function() {
            $('#edit_old_patient option').prop('selected', function() {
                return this.defaultSelected;
            });
            $('#edit_doctor_charge, #edit_discount, #edit_hospital_commission').val('');
        });

        function getOpdVisitData(id) {
            $.ajax({
                url: '<?php echo site_url('opd/get_opd_visit_details/') ?>' + id,
                dataType: 'json',
                success: function(data) {
                    $('#edit_id').val(data.id);
                    $('#edit_patient_id').val(data.patient_id);
                    $('#edit_appointment_date').val(data.appointment_date);
                    $('#edit_doctor_id').val(data.doctor_id).trigger('change');
                    $('#edit_casualty').val(data.casualty);
                    $('#edit_old_patient').val(data.old_patient);
                    $('#edit_doctor_charge').val(data.doctor_charge);
                    $('#edit_discount').val(data.discount);
                    $('#edit_hospital_commission').val(data.hospital_commission);
                    $('#edit_reference_id').val(data.reference_id).trigger('change');
                    $('#edit_payment_status').val(data.payment_status);
                    $('#edit_height').val(data.height);
                    $('#edit_weight').val(data.weight);
                    $('#edit_bp').val(data.bp);
                    $('#edit_symptoms').val(data.symptoms);
                    $('#edit_case').val(data.case);
                    $('#edit_note').val(data.note);
                    $('#is_discount').val(data.is_discount);
                    $('#is_limit').val(data.is_limit);
                    $('#discount_limit').val(data.discount_limit);

                    if (data.is_discount == 0) {
                        document.getElementById("edit_discount").disabled = true;
                        $('#edit_discount').val('');
                    }
                }
            });
        }

        $(document).ready(function(e) {
            $("#editVisitForm").on('submit', (function(e) {
                e.preventDefault();
                if ($("#edit_old_patient").val() != "" && $("#edit_doctor_charge").val() != "") {
                    // if ($("#edit_discount").val() < Math.floor($("#edit_hospital_commission").val())) {
                    //     $.confirm({
                    //         title: 'Warning! Attention Please!!!',
                    //         content: 'Discount amount is not more than ' + Math.floor($("#edit_hospital_commission").val()),
                    //         type: 'red',
                    //         typeAnimated: true,
                    //         buttons: {
                    //             close: function() {}
                    //         }
                    //     });

                    if ($("#is_limit").val() == 1 && $("#edit_discount").val() > Math.floor($("#discount_limit").val())) {
                        $.confirm({
                            title: 'Warning! Attention Please!!!',
                            content: 'Discount amount is not more than ' + Math.floor($("#discount_limit").val()),
                            type: 'red',
                            typeAnimated: true,
                            buttons: {
                                close: function() {}
                            }
                        });
                    } else {
                        $.ajax({
                            url: '<?php echo site_url('opd/editVisit') ?>',
                            type: "POST",
                            data: new FormData(this),
                            dataType: 'json',
                            contentType: false,
                            cache: false,
                            processData: false,
                            success: function(data) {
                                if (data.status == "failed") {
                                    var message = "";
                                    $.each(data.error, function(index, value) {
                                        $("." + index).html(value);
                                        message += value;
                                    });
                                    $.toast({
                                        text: message,
                                        position: 'top-right',
                                        loaderBg: '#7a5449',
                                        class: 'jq-toast-danger',
                                        hideAfter: 3500,
                                        stack: 6,
                                        showHideTransition: 'fade'
                                    });
                                } else {
                                    $.toast({
                                        text: data.message,
                                        position: 'top-right',
                                        loaderBg: '#7a5449',
                                        class: 'jq-toast-primary',
                                        hideAfter: 3500,
                                        stack: 6,
                                        showHideTransition: 'fade'
                                    });
                                    location.reload(true);
                                }
                            }
                        });
                    }
                } else {
                    $.toast({
                        text: "Please select all required field",
                        position: 'top-right',
                        loaderBg: '#7a5449',
                        class: 'jq-toast-danger',
                        hideAfter: 3500,
                        stack: 6,
                        showHideTransition: 'fade'
                    });
                }
            }));
        });
    </script>

    <script type="text/javascript">
        function get_doctor_charge(is_old_patient) {
            $.ajax({
                type: "POST",
                url: "<?php echo site_url('opd/get_doctor_charge'); ?>",
                data: {
                    user_id: $('#edit_doctor_id').val(),
                    old_patient: is_old_patient,
                },
                dataType: 'json',
                success: function(response) {
                    if (response) {
                        $('#edit_doctor_charge').val(response.charge);
                        if (response.is_discount == 1 && is_old_patient == 0) {
                            $('#edit_discount').val('');
                            document.getElementById("edit_discount").disabled = false;
                        } else {
                            document.getElementById("edit_discount").disabled = true;
                            $('#edit_discount').val('');
                        }
                    } else {
                        $('#edit_doctor_charge').val('0');
                        $('#edit_discount').val('0');
                    }
                    // if (response) {
                    //     $('#edit_doctor_charge').val(response.charge);
                    //     if (response.hospital_commission > 0) {
                    //         $('#edit_discount').val('');
                    //         document.getElementById("edit_discount").disabled = false;
                    //     } else {
                    //         document.getElementById("edit_discount").disabled = true;
                    //         $('#edit_discount').val('');
                    //     }
                    //     $('#edit_hospital_commission').val(response.hospital_commission);
                    // } else {
                    //     $('#edit_doctor_charge').val('0');
                    //     $('#edit_discount').val('0');
                    //     $('#edit_hospital_commission').val('0');
                    // }
                }
            });
        }
    </script>

<?php } ?>

<?php if (has_permission(VIEW, 'opd', 'opd')) { ?>
    <div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header bg-gradient-primary">
                    <h5 class="modal-title text-white"><?php echo $this->lang->line('bill'); ?> <?php echo $this->lang->line('info'); ?></h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body modal_data bg-gradient-secondary"></div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        function get_view_modal(id) {
            $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
            $.ajax({
                type: "POST",
                url: "<?php echo site_url('opd/get_single_visit'); ?>",
                data: {
                    id: id
                },
                success: function(response) {
                    if (response) {
                        $('.modal_data').html(response);
                    }
                }
            });
        }
    </script>
<?php } ?>

<script>
    function printVisitBill(patient_id, opd_id) {
        var base_url = '<?php echo base_url() ?>';
        $.ajax({
            url: base_url + 'opd/get_patient_visit_bill',
            type: 'POST',
            data: {
                patient_id: patient_id,
                opd_id: opd_id
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function popup(data) {
        var base_url = '<?php echo base_url() ?>';
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title>Invoice</title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
            //window.location.reload(true);
        }, 500);

        return true;

    }
</script>


<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<script>
    $(".select2").select2();
</script>