<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Ipd_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_doctor_list() {
        $this->db->select('C.*, E.*');
        $this->db->from('doctor_charges AS C');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_ipd_patient_list($type, $form_date, $to_date, $doctor_id, $reference_id) {
        $this->db->select('IP.*, P.patient_unique_id, P.name as patient_name, P.phone, P.address, P.gender, P.photo, D.name as doctor, R.name as reference');
        $this->db->from('ipd_patients AS IP');
        $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
        $this->db->join('users AS U', 'U.id = P.user_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IP.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = IP.reference_id', 'left');
        if ($type == 1) {
            $this->db->where('IP.discharged', '0');
        }
        if ($type == 2) {
            $this->db->where('IP.discharged', '1');
        }
        if ($type == 3) {
            $this->db->where('IP.reference_id >', 0);
        }
        if ($type == 4) {
            $this->db->group_start();
            $this->db->where('IP.reference_id', 0);
            $this->db->or_where('IP.reference_id', NULL);
            $this->db->or_where('IP.reference_id', '');
            $this->db->group_end();
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(IP.admission_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('IP.doctor_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('IP.reference_id', $reference_id);
        }
        $this->db->order_by('IP.created_at', 'DESC');
        $this->db->group_by('IP.patient_id');
        return $this->db->get()->result();
    }

    public function get_sms_list($limit, $offset, $search, $count) {
        $this->db->select('TM.*, R.name as role, E.name as created_by');
        $this->db->from('text_messages AS TM');
        $this->db->join('roles AS R', 'R.id = TM.role_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = TM.created_by', 'left');
        if ($search) {
            $this->db->like('TM.body', $search, 'both');
            $this->db->or_like('R.name', $search, 'both');
            $this->db->or_like('E.name', $search, 'both');
        }
        $this->db->where('TM.sms_type', 'ipd_patient');
        $this->db->order_by('TM.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
}
