<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Employee_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_employee_list($department_id, $designation_id, $gender, $religion) {
        $this->db->select('E.*, D.name AS department, DE.name AS designation, U.device_id');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->join('departments AS D', 'D.id = E.department_id', 'left');
        $this->db->join('designations AS DE', 'DE.id = E.designation_id', 'left');
        if ($department_id) {
            $this->db->where('E.department_id', $department_id);
        }
        if ($designation_id) {
            $this->db->where('E.designation_id', $designation_id);
        }
        if ($gender) {
            $this->db->where('E.gender', $gender);
        }
        if ($religion) {
            $this->db->where('E.religion', $religion);
        }
        $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, PATHOLOGIST, RADIOLOGIST, NURSE, RECEPTIONIST, STAFF, MARKETING, PHARMACIST));
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_sms_list($limit, $offset, $search, $count) {
        $this->db->select('TM.*, R.name as role, E.name as created_by');
        $this->db->from('text_messages AS TM');
        $this->db->join('roles AS R', 'R.id = TM.role_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = TM.created_by', 'left');
        if ($search) {
            $this->db->like('TM.body', $search, 'both');
            $this->db->or_like('R.name', $search, 'both');
            $this->db->or_like('E.name', $search, 'both');
        }
        $this->db->where('TM.sms_type', 'employee');
        $this->db->order_by('TM.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
}
