<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Email.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Email
 * @description     : Manage Email.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Email extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Email_Model', 'email', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Email List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage_email') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('email/index', $this->data);
    }
}
