<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('leave'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_leave'); ?>
        </h4>
        <div class="align-items-center">
            <?php if (has_permission(VIEW, 'leave', 'application')) { ?>
                <button class="btn btn-sm btn-outline-light btn-wth-icon icon-wthot-bg mr-15" onclick="print(<?php echo $application->id; ?>);">
                    <span class="icon-label"><i class="fa fa-print"></i> </span>
                    <span class="btn-text"><?php echo $this->lang->line('print'); ?> </span>
                </button>
            <?php } ?>

            <?php if (has_permission(VIEW, 'leave', 'application')) { ?>
                <a href="<?php echo site_url('leave/application'); ?>" class="btn btn-primary btn-sm mr-15"><?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('application'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper hk-invoice-wrap pa-35">
                <div class="invoice-to-wrap pb-0">
                    <div class="row">
                        <div class="col-md-8 mb-30">
                            <span class="d-block text-uppercase mb-5 font-13">application from</span>
                            <h6 class="mb-5 text-uppercase"><?php echo $application->name; ?> [<?php echo $application->device_id; ?>]</h6>
                            <address>
                                <span class="d-block">Designation : <?php echo $application->designation; ?></span>
                                <span class="d-block">Mobile No : <?php echo $application->phone; ?></span>
                                <span class="d-block">Address : <?php echo $application->present_address; ?></span>
                                <?php if ($application->approved_by) { ?>
                                    <span class="d-block text-red">Approved By : <?php echo $application->approved_by; ?></span>
                                    <span class="d-block">Approved Date : <?php echo $application->modified_by ? date('M d, Y, h:ia', strtotime($application->modified_at)) : ''; ?></span>
                                <?php } ?>
                            </address>
                        </div>
                        <div class="col-md-4 mb-30">
                            <span class="d-block text-uppercase mb-5 font-13">Approved from</span>
                            <h6 class="mb-5 text-uppercase"><?php echo $this->global_setting->brand_title; ?></h6>
                            <address>
                                <span class="d-block"><?php echo $this->global_setting->address; ?></span>
                                <span class="d-block">Phone: <?php echo $this->global_setting->phone; ?></span>
                                <span class="d-block">Email: <?php echo $this->global_setting->email; ?></span>
                                <span class="d-block text-red">Applied Date: <?php echo date('M d, Y, h:ia', strtotime($application->created_at)); ?></span>
                            </address>
                        </div>
                    </div>
                </div>
                <div class="invoice-details">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm table-border mb-0">
                                <thead class="text-center bg-gradient-sunset">
                                    <tr>
                                        <th colspan="4" class="text-white font-weight-700 text-center text-uppercase font-20"><?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('info'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="text-left"><?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('type'); ?></td>
                                        <td class="text-left"><?php echo $application->type; ?></td>
                                        <td class="text-left"><?php echo $this->lang->line('attachment'); ?></td>
                                        <td class="text-left">
                                            <?php if ($application->attachment) { ?>
                                                <a target="_blank" href="<?php echo UPLOAD_PATH; ?>attachment/<?php echo $application->attachment; ?>" class="btn btn-success btn-xs"><i class="fa fa-download"></i> <?php echo $this->lang->line('download'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-left"><?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('from'); ?></td>
                                        <td class="text-left"><?php echo date('M d, Y', strtotime($application->leave_from)); ?></td>
                                        <td class="text-left"><?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('to'); ?></td>
                                        <td class="text-left"><?php echo date('M d, Y', strtotime($application->leave_to)); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-left"><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('leave'); ?></td>
                                        <td class="text-left"><span class="badge badge-info"><?php echo $application->total_leave_day; ?> <?php echo $this->lang->line('day'); ?></span></td>
                                        <td class="text-left"><?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('status'); ?></td>
                                        <td class="text-left">
                                            <?php if ($application->leave_status == 'waiting') {
                                                echo "<span class='badge badge-info'>" . $this->lang->line('waiting') . "</span>";
                                            } elseif ($application->leave_status == 'approved') {
                                                echo "<span class='badge badge-success'>" . $this->lang->line('approved') . "</span>";
                                            } else {
                                                echo "<span class='badge badge-danger'>" . $this->lang->line('declined') . "</span>";
                                            } ?>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php if ($application->reason) { ?>
                        <blockquote class="blockquote mt-4">
                            <?php echo $this->lang->line('reason'); ?>
                        </blockquote>
                        <p class="text-justify"><?php echo $application->reason; ?></p>
                    <?php } ?>

                    <?php if ($application->remark) { ?>
                        <blockquote class="blockquote mt-4">
                            <?php echo $this->lang->line('remark'); ?>
                        </blockquote>
                        <p class="text-justify"><?php echo $application->remark; ?></p>
                    <?php } ?>
                </div>
            </section>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->



<script>
    function print(id) {
        $.ajax({
            url: '<?php echo site_url('leave/application/print'); ?>',
            type: 'POST',
            data: {
                id: id,
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function popup(data) {
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title>Print</title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
        }, 500);
        return true;
    }
</script>