<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('leave'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_leave'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('leave/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'leave', 'application')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-paper-plane font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('application'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'leave', 'application')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('leave/application'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('application'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('leave/application/edit/' . $application->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="leave_type_id"><?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select select2" name="leave_type_id" id="leave_type_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($types as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($application->leave_type_id) && $application->leave_type_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->type; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="leave_type_id" class="form-text text-muted">
                                <?php echo form_error('leave_type_id'); ?>
                            </small>
                        </div>

                        <?php if ($this->session->userdata('role_id') == SUPER_ADMIN || $this->session->userdata('role_id') == ADMIN) { ?>
                            <div class="col-md-5 mb-10">
                                <label for="user_id"><?php echo $this->lang->line('employee'); ?></label>
                                <select class="form-control custom-select select2" name="user_id" id="user_id" required>
                                    <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                    <?php foreach ($employees as $obj) { ?>
                                        <option value="<?php echo $obj->user_id; ?>" <?php echo isset($application->user_id) && $application->user_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                    <?php } ?>
                                </select>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                                <div class="invalid-feedback">
                                    <?php echo $this->lang->line('required_field'); ?>
                                </div>
                                <small id="user_id" class="form-text text-muted">
                                    <?php echo form_error('user_id'); ?>
                                </small>
                            </div>
                        <?php } else { ?>
                            <input type="hidden" name="user_id" value="<?php echo $this->session->userdata('user_id'); ?>">
                        <?php } ?>

                        <div class="col-md-2 mb-10">
                            <label for="leave_from"><?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('from'); ?></label>
                            <input type="text" class="form-control" name="leave_from" id="leave_from" value="<?php echo isset($application->leave_from) ?  $application->leave_from : ''; ?>" placeholder="<?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('from'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="leave_from" class="form-text text-muted">
                                <?php echo form_error('leave_from'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="leave_to"><?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('to'); ?></label>
                            <input type="text" class="form-control" name="leave_to" id="leave_to" value="<?php echo isset($application->leave_to) ?  $application->leave_to : ''; ?>" placeholder="<?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('to'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="leave_to" class="form-text text-muted">
                                <?php echo form_error('leave_to'); ?>
                            </small>
                        </div>
                        <?php if ($this->session->userdata('role_id') != SUPER_ADMIN && $this->session->userdata('role_id') != ADMIN) { ?>
                            <div class="col-md-5 mb-10">
                                <label for="attachment"><?php echo $this->lang->line('attachment'); ?></label>
                                <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                    </div>
                                    <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                    <span class="input-group-append">
                                        <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                            <input type="file" name="attachment">
                                            <input type="hidden" name="prev_attachment" value="<?php echo $application->attachment; ?>">
                                        </span>
                                        <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                    </span>
                                </div>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        <?php } ?>
                        <div class="col-md-12 mb-10">
                            <label for="reason"><?php echo $this->lang->line('reason'); ?></label>
                            <div class="tinymce-wrap">
                                <textarea class="tinymce" name="reason" id="reason"><?php echo isset($application->reason) ?  $application->reason : ''; ?></textarea>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <?php if ($this->session->userdata('role_id') == SUPER_ADMIN || $this->session->userdata('role_id') == ADMIN) { ?>
                            <div class="col-md-12 mt-10 mb-10">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                                    </div>
                                    <textarea rows="5" class="form-control" name="remark" id="remark" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($application->remark) ?  $application->remark : ''; ?></textarea>
                                    <div class="valid-feedback">
                                        <?php echo $this->lang->line('looks_good'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-8 mb-10">
                                <label for="attachment"><?php echo $this->lang->line('attachment'); ?></label>
                                <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                    </div>
                                    <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                    <span class="input-group-append">
                                        <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                            <input type="file" name="attachment">
                                            <input type="hidden" name="prev_attachment" value="<?php echo $application->attachment; ?>">
                                        </span>
                                        <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                    </span>
                                </div>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                            <div class="col-md-4 mb-10">
                                <label for="status"><?php echo $this->lang->line('status'); ?></label>
                                <select class="form-control custom-select" name="leave_status" id="leave_status" required>
                                    <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                    <option value="waiting" <?php echo isset($application->leave_status) && $application->leave_status == 'waiting' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('waiting'); ?></option>
                                    <option value="approved" <?php echo isset($application->leave_status) && $application->leave_status == 'approved' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('approved'); ?></option>
                                    <option value="declined" <?php echo isset($application->leave_status) && $application->leave_status == 'declined' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('declined'); ?></option>
                                </select>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                                <div class="invalid-feedback">
                                    <?php echo $this->lang->line('required_field'); ?>
                                </div>
                                <small id="leave_status" class="form-text text-muted">
                                    <?php echo form_error('leave_status'); ?>
                                </small>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" value="<?php echo $application->id; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('leave/application'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
    $("#leave_from, #leave_to").daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY-MM-DD'
        }
    });
</script>

<!-- Tinymce JavaScript -->
<script src="<?php echo VENDOR_URL; ?>tinymce/tinymce.min.js"></script>
<script>
    $(function() {
        "use strict";
        tinymce.init({
            selector: '.tinymce',
            height: 200,
            plugins: [
                'advlist autolink lists link image charmap print preview anchor',
                'searchreplace visualblocks code fullscreen',
                'insertdatetime media table contextmenu paste code'
            ],
            toolbar: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
        });
    });
</script>