<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Application_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') != SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, PATHOLOGIST, RADIOLOGIST, NURSE, RECEPTIONIST, STAFF, MARKETING, PHARMACIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_approved_by_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') != SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_application_list($limit, $offset, $leave_type_id, $leave_status, $form_date, $to_date, $user_id, $approved_by, $keyword, $count) {
        $this->db->select('L.*, LT.type, E.name, E.phone, D.name as designation');
        $this->db->from('leaves AS L');
        $this->db->join('leave_types AS LT', 'LT.id = L.leave_type_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = L.user_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        if ($leave_type_id) {
            $this->db->where('L.leave_type_id', $leave_type_id);
        }
        if ($leave_status) {
            $this->db->where('L.leave_status', $leave_status);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(L.leave_from) AND DATE(L.leave_to) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($user_id) {
            $this->db->where('L.user_id', $user_id);
        }
        if ($approved_by) {
            $this->db->where('L.modified_by', $approved_by);
        }
        if ($keyword) {
            $this->db->like('E.phone', $keyword, 'both');
            $this->db->or_like('E.name', $keyword, 'both');
            $this->db->or_like('L.reason', $keyword, 'both');
        }
        $this->db->order_by('L.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_application($id) {
        $this->db->select('L.*, U.device_id, LT.type, E.name, E.phone, E.gender, E.present_address, D.name as designation, A.name as approved_by');
        $this->db->from('leaves AS L');
        $this->db->join('leave_types AS LT', 'LT.id = L.leave_type_id', 'left');
        $this->db->join('users AS U', 'U.id = L.user_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = L.user_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        $this->db->join('employees AS A', 'A.user_id = L.modified_by', 'left');
        $this->db->where('L.id', $id);
        return $this->db->get()->row();
    }
}
