<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('ipd'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Row -->
    <div class="row">
        <?php echo $this->load->view('ipd/patient-info'); ?>

        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'ipd', 'surgeon')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user-md font-30 mr-10"></i>
                            <?php echo $this->lang->line('surgeon'); ?> <?php echo $this->lang->line('chart'); ?>
                        </h6>
                    <?php } ?>
                    <?php echo form_open_multipart(site_url('ipd/surgeon/index/' . $patient->id), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>">
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>

                    <?php if ($patient->discharged == 0 || $this->session->userdata('role_id') == SUPER_ADMIN ||  !empty(custom_permission('modified_discharged'))) { ?>
                        <?php if (has_permission(ADD, 'ipd', 'surgeon')) { ?>
                            <div class="align-items-center">
                                <button type="button" class="btn btn-xs btn-primary" data-toggle="modal" data-target="#addSurgeonModal">
                                    <i class="fa fa-plus font-12 mr-5"></i>
                                    <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('surgeon'); ?>
                                </button>
                            </div>
                        <?php } ?>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('surgeon'); ?></th>
                                        <th><?php echo $this->lang->line('charge'); ?></th>
                                        <th><?php echo $this->lang->line('instruction'); ?></th>
                                        <th><?php echo $this->lang->line('payment'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th class="w-15"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($surgeons) && !empty($surgeons)) { ?>
                                        <?php foreach ($surgeons as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo date('d/m/Y h:i A', strtotime($obj->date)); ?></td>
                                                <td><?php echo $obj->doctor; ?></td>
                                                <td><?php echo $obj->charge; ?></td>
                                                <td><?php echo $obj->instruction; ?></td>
                                                <td><?php echo $obj->paid_status == 'paid' ? "<span class='badge badge-success'>" . $this->lang->line('paid') . "</span>" : "<span class='badge badge-danger'>" . $this->lang->line('unpaid') . "</span>"; ?></td>
                                                <td>
                                                    <?php if ($obj->surgeon_status == 'complete') {
                                                        echo "<span class='badge badge-success'>" . $this->lang->line('complete') . "</span>";
                                                    } elseif ($obj->surgeon_status == 'rejected') {
                                                        echo "<span class='badge badge-danger'>" . $this->lang->line('rejected') . "</span>";
                                                    } elseif ($obj->surgeon_status == 'canceled') {
                                                        echo "<span class='badge badge-warning'>" . $this->lang->line('cancel') . "</span>";
                                                    } else {
                                                        echo "<span class='badge badge-info'>" . $this->lang->line('pending') . "</span>";
                                                    } ?>
                                                </td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'ipd', 'surgeon')) { ?>
                                                        <button type="button" onclick="get_view_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                    <?php } ?>

                                                    <?php if ($patient->discharged == 0 || $this->session->userdata('role_id') == SUPER_ADMIN ||  !empty(custom_permission('modified_discharged'))) { ?>
                                                        <?php if ($obj->paid_status != 'paid') { ?>
                                                            <?php if (has_permission(EDIT, 'ipd', 'surgeon')) { ?>
                                                                <button type="button" onclick="editSurgeon('<?php echo $obj->id; ?>')" class="btn btn-xs btn-success" data-toggle="modal" data-target="#editSurgeonModal">
                                                                    <i class="fa fa-pencil-square-o"></i>
                                                                </button>
                                                            <?php } ?>
                                                            <?php if (has_permission(DELETE, 'ipd', 'surgeon')) { ?>
                                                                <a class="btn btn-xs btn-danger round" href="<?php echo site_url('ipd/surgeon/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i></a>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="8"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Add Consultan Modal-->
<div class="modal fade" id="addSurgeonModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('surgeon'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="addSurgeonForm" enctype="multipart/form-data" method="POST" action="<?php echo site_url('ipd/surgeon/add'); ?>">
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('surgeon'); ?></label>
                            <select class="form-control custom-select select2" name="doctor_id" id="doctor_id" onchange="get_charge(this.value)" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="charge"><?php echo $this->lang->line('charge'); ?></label>
                            <input type="text" class="form-control" name="charge" id="charge" value="<?php echo isset($charge) ?  $charge : ''; ?>" placeholder="<?php echo $this->lang->line('charge'); ?>" required>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="date" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" required>
                        </div>
                        <div class="col-md-12 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('instruction'); ?></span>
                                </div>
                                <textarea class="form-control" name="instruction" id="instruction" aria-label="<?php echo $this->lang->line('instruction'); ?>"><?php echo isset($instruction) ?  $instruction : ''; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="ipd_id" value="<?php echo $patient->id; ?>">
                        <input type="hidden" name="patient_id" value="<?php echo $patient->patient_id; ?>">
                        <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Surgeon Modal-->
<div class="modal fade" id="editSurgeonModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('surgeon'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="editSurgeonForm" enctype="multipart/form-data" method="POST" action="#">
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-md-5 mb-10">
                            <label for="edit_doctor_id"><?php echo $this->lang->line('surgeon'); ?></label>
                            <select class="form-control custom-select select2" name="doctor_id" id="edit_doctor_id" onchange="edit_get_charge(this.value)" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="edit_charge"><?php echo $this->lang->line('charge'); ?></label>
                            <input type="text" class="form-control" name="charge" id="edit_charge" value="<?php echo isset($charge) ?  $charge : ''; ?>" placeholder="<?php echo $this->lang->line('charge'); ?>" required>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="edit_date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="edit_date" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" required>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="edit_surgeon_status"><?php echo $this->lang->line('status'); ?></label>
                            <select class="form-control custom-select" name="surgeon_status" id="edit_surgeon_status" required>
                                <?php $invoice_status = get_invoice_status(); ?>
                                <?php foreach ($invoice_status as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($surgeon_status) && $surgeon_status == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-12 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('instruction'); ?></span>
                                </div>
                                <textarea class="form-control" name="instruction" id="edit_instruction" aria-label="<?php echo $this->lang->line('instruction'); ?>"><?php echo isset($instruction) ?  $instruction : ''; ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-12 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                                </div>
                                <textarea class="form-control" name="note" id="edit_note" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="surgeon_id" id="edit_surgeon_id">
                        <input type="hidden" name="ipd_id" id="edit_ipd_id" value="<?php echo $patient->id; ?>">
                        <input type="hidden" name="patient_id" id="edit_patient_id" value="<?php echo $patient->patient_id; ?>">
                        <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>


<script>
    function editSurgeon(id) {
        $.ajax({
            url: '<?php echo site_url('ipd/surgeon/get_surgeon/') ?>' + id,
            dataType: 'json',
            success: function(data) {
                $('#edit_surgeon_id').val(data.id);
                $('#edit_ipd_id').val(data.ipd_id);
                $('#edit_patient_id').val(data.patient_id);
                $('#edit_doctor_id').val(data.doctor_id).trigger('change');
                $('#edit_charge').val(Math.floor(data.charge));
                $('#edit_date').val(data.date);
                $('#edit_instruction').val(data.instruction);
                $('#edit_surgeon_status').val(data.surgeon_status);
                $('#edit_note').val(data.note);
            }
        });
    }

    $(document).ready(function(e) {
        $("#editSurgeonForm").on('submit', (function(e) {
            e.preventDefault();
            if ($("#edit_doctor_id").val() != "" && $("#edit_date").val() != "") {
                $.ajax({
                    url: '<?php echo site_url('ipd/surgeon/edit') ?>',
                    type: "POST",
                    data: new FormData(this),
                    dataType: 'json',
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(data) {
                        if (data.status == "failed") {
                            var message = "";
                            $.each(data.error, function(index, value) {
                                $("." + index).html(value);
                                message += value;
                            });
                            $.toast({
                                text: message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-danger',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                        } else {
                            $.toast({
                                text: data.message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-primary',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                            location.reload(true);
                        }
                        $('#editSurgeonForm').find('form')[0].reset();
                    },
                    error: function() {
                        alert("Fail")
                    }
                });
            } else {
                $.toast({
                    text: "Please select all required field",
                    position: 'top-right',
                    loaderBg: '#7a5449',
                    class: 'jq-toast-danger',
                    hideAfter: 3500,
                    stack: 6,
                    showHideTransition: 'fade'
                });
            }
        }));
    });
</script>

<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('surgeon'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ipd/surgeon/get_single_surgeon'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();

    $('#date, #edit_date').daterangepicker({
        singleDatePicker: true,
        startDate: new Date(),
        showDropdowns: true,
        minYear: 1901,
        timePicker: true,
        timePicker24Hour: true,
        timePickerIncrement: 1,
        timePickerSeconds: false,
        autoUpdateInput: true,
        autoApply: true,
        locale: {
            format: 'YYYY-MM-DD HH:mm',
        }
    });
</script>

<script type="text/javascript">
    function get_charge(doctor_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ipd/surgeon/get_doctor_charge'); ?>",
            data: {
                user_id: doctor_id
            },
            dataType: 'json',
            success: function(response) {
                if (response) {
                    $('#charge').val(Math.floor(response.charge));
                } else {
                    $('#charge').val('0');
                }
            }
        });
    }
</script>

<script type="text/javascript">
    function edit_get_charge(doctor_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ipd/surgeon/get_doctor_charge'); ?>",
            data: {
                user_id: doctor_id
            },
            dataType: 'json',
            success: function(response) {
                if (response) {
                    $('#edit_charge').val(Math.floor(response.charge));
                } else {
                    $('#edit_charge').val('0');
                }
            }
        });
    }
</script>