<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Ipd_Model extends MY_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_total_investigation_due($patient_id)
    {
        $this->db->select('SUM(I.due_amount) as total_investigation_due');
        $this->db->from('invoices AS I');
        $this->db->where('I.patient_id', $patient_id);
        $this->db->where('I.paid_status', 'unpaid');
        $this->db->where('I.payment_status', 'complete');
        return $this->db->get()->row()->total_investigation_due;
    }

    public function get_total_pharmacy_due($patient_id)
    {
        $this->db->select('SUM(I.due_amount) as total_pharmacy_due');
        $this->db->from('medicine_invoices AS I');
        $this->db->where('I.customer_id', $patient_id);
        $this->db->where('I.paid_status', 'unpaid');
        $this->db->where('I.payment_status', 'complete');
        return $this->db->get()->row()->total_pharmacy_due;
    }

    public function get_total_ipd_advaced($ipd_id, $patient_id)
    {
        $this->db->select('SUM(IP.amount) as total_ipd_advanced');
        $this->db->from('ipd_advance_payments AS IP');
        $this->db->where('IP.ipd_id', $ipd_id);
        $this->db->where('IP.patient_id', $patient_id);
        $this->db->where('IP.payment_status', 'complete');
        return $this->db->get()->row()->total_ipd_advanced;
    }

    public function get_doctor_list()
    {
        $this->db->select('C.*, E.name, E.phone, E.user_id');
        $this->db->from('doctor_charges AS C');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_nurse_list()
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', NURSE);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_employee_list()
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') != SUPER_ADMIN) {
            $this->db->where('U.role_id !=', SUPER_ADMIN);
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_contract_person_list()
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_bed_group_list()
    {
        $this->db->select('BG.*, F.name as floor_name');
        $this->db->from('bed_groups AS BG');
        $this->db->join('floors AS F', 'F.id = BG.floor_id', 'left');
        $this->db->where('BG.status', '1');
        $this->db->order_by('BG.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_admitted_list($limit, $offset, $search, $count)
    {
        $this->db->select('IP.*, P.patient_unique_id, P.name as patient_name, D.name as doctor_name, BG.name as ward_name, B.name as bed, F.name as floor');
        $this->db->from('ipd_patients AS IP');
        $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IP.doctor_id', 'left');
        $this->db->join('bed_groups AS BG', 'BG.id = IP.bed_group_id', 'left');
        $this->db->join('beds AS B', 'B.id = IP.bed_id', 'left');
        $this->db->join('floors AS F', 'F.id = BG.floor_id', 'left');
        if ($search) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.phone', $search);
            $this->db->or_like('P.name', $search);
            $this->db->or_like('P.address', $search);
            $this->db->group_end();
        }
        $this->db->where('IP.discharged', 0);
        $this->db->order_by('IP.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check($name, $phone, $id = null)
    {
        if ($id) {
            $this->db->where_not_in('user_id', $id);
        }
        $this->db->where('name', $name);
        $this->db->where('phone', $phone);
        return $this->db->get('patients')->num_rows();
    }

    public function get_patient_list($limit, $offset, $search, $count)
    {
        $this->db->select('P.*');
        $this->db->from('patients AS P');
        if ($search) {
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.phone', $search);
            $this->db->or_like('P.name', $search);
            $this->db->or_like('P.address', $search);
        }
        $this->db->order_by('P.id', 'ASC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_ipd_patient($ipd_id)
    {
        $this->db->select('IP.*, D.name as doctor, D.specialist, C.name as contract_person, R.name as reference, R.phone as reference_phone, CB.name as created_by, MB.name as modified_by, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.guardian_name, P.phone, P.address, BG.name as ward_name, B.name as bed, F.name as floor');
        $this->db->from('ipd_patients AS IP');
        $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IP.doctor_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = IP.contract_person', 'left');
        $this->db->join('employees AS R', 'R.user_id = IP.reference_id', 'left');
        $this->db->join('employees AS CB', 'CB.user_id = IP.created_by', 'left');
        $this->db->join('employees AS MB', 'MB.user_id = IP.modified_by', 'left');
        $this->db->join('bed_groups AS BG', 'BG.id = IP.bed_group_id', 'left');
        $this->db->join('beds AS B', 'B.id = IP.bed_id', 'left');
        $this->db->join('floors AS F', 'F.id = BG.floor_id', 'left');
        $this->db->where('IP.id', $ipd_id);
        return $this->db->get()->row();
    }

    public function get_discharge_list($limit, $offset, $search, $form_date = null, $to_date = null, $count = 0)
    {
        $this->db->select('IP.*, I.id as invoice_id, I.total_bill, I.advanced, I.due_amount, P.patient_unique_id, P.name as patient_name, D.name as doctor_name, BG.name as ward_name, B.name as bed, F.name as floor');
        $this->db->from('ipd_patients AS IP');
        $this->db->join('ipd_invoices AS I', 'I.ipd_id = IP.id', 'left');
        $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IP.doctor_id', 'left');
        $this->db->join('bed_groups AS BG', 'BG.id = IP.bed_group_id', 'left');
        $this->db->join('beds AS B', 'B.id = IP.bed_id', 'left');
        $this->db->join('floors AS F', 'F.id = BG.floor_id', 'left');
        if ($search) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.phone', $search);
            $this->db->or_like('P.name', $search);
            $this->db->group_end();
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(IP.discharged_date) BETWEEN '$form_date' AND '$to_date'");
        }
        $this->db->where('IP.discharged', 1);
        $this->db->where('I.payment_status', 'complete');
        $this->db->order_by('IP.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_service_search($search)
    {
        $this->db->select('C.*');
        $this->db->from('charges AS C');
        if ($search) {
            $this->db->like('C.name', $search, 'both');
            $this->db->or_like('C.code', $search, 'both');
        }
        $this->db->order_by('C.name', 'ASC');
        $this->db->limit(10);
        return $this->db->get()->result_array();
    }


    public function get_commission_search($search)
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        if ($search) {
            $this->db->group_start();
            $this->db->like('E.name', $search, 'both');
            $this->db->or_like('E.phone', $search, 'both');
            $this->db->or_like('E.id', $search, 'both');
            $this->db->or_like('E.user_id', $search, 'both');
            $this->db->group_end();
        }
        $this->db->where('E.status', 1);
        $this->db->order_by('E.name', 'ASC');
        $this->db->limit(20);
        return $this->db->get()->result();
    }

    public function get_total_sum($ipd_id)
    {
        $this->db->select_sum('charge');
        $this->db->where('ipd_id', $ipd_id);
        return $this->db->get('ipd_consultant_visits')->row()->charge;
    }

    public function get_total_bed_fee($ipd_id)
    {
        $this->db->select_sum('charge');
        $this->db->where('ipd_id', $ipd_id);
        return $this->db->get('ipd_consultant_visits')->row()->charge;
    }

    public function get_patient_total_advance($ipd_id, $patient_id)
    {
        $this->db->select_sum('amount');
        $this->db->from('ipd_advance_payments');
        $this->db->where('ipd_id', $ipd_id);
        $this->db->where('patient_id', $patient_id);
        $this->db->where('payment_status', 'complete');
        return $this->db->get()->row()->amount;
    }

    public function get_patient_bed_list($ipd_id, $patient_id)
    {
        $this->db->select('IB.*, B.price, B.name, BG.name as bed_group');
        $this->db->from('ipd_beds AS IB');
        $this->db->join('beds AS B', 'B.id = IB.bed_id', 'left');
        $this->db->join('bed_groups AS BG', 'BG.id = B.group_id', 'left');
        $this->db->where('IB.ipd_id', $ipd_id);
        $this->db->where('IB.patient_id', $patient_id);
        $this->db->order_by('IB.from_date', 'ASC');
        return $this->db->get()->result();
    }

    public function get_patient_surgeon_list($ipd_id, $patient_id)
    {
        $this->db->select('IS.*, D.name as surgeon');
        $this->db->from('ipd_surgeons AS IS');
        $this->db->join('employees AS D', 'D.user_id = IS.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = D.user_id', 'left');
        $this->db->where('IS.ipd_id', $ipd_id);
        $this->db->where('IS.patient_id', $patient_id);
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('IS.surgeon_status', 'complete');
        $this->db->order_by('IS.date', 'ASC');
        return $this->db->get()->result();
    }

    public function get_patient_anesthesia_list($ipd_id, $patient_id)
    {
        $this->db->select('IA.*, A.name as anesthesia');
        $this->db->from('ipd_anesthesias AS IA');
        $this->db->join('anesthetists AS A', 'A.user_id = IA.doctor_id', 'left');
        $this->db->where('IA.ipd_id', $ipd_id);
        $this->db->where('IA.patient_id', $patient_id);
        $this->db->where('IA.anesthesia_status', 'complete');
        $this->db->order_by('IA.date', 'ASC');
        return $this->db->get()->result();
    }

    public function get_patient_assistant_list($ipd_id, $patient_id)
    {
        $this->db->select('IA.*, A.name as assistant');
        $this->db->from('ipd_assistants AS IA');
        $this->db->join('assistants AS A', 'A.user_id = IA.doctor_id', 'left');
        $this->db->where('IA.ipd_id', $ipd_id);
        $this->db->where('IA.patient_id', $patient_id);
        $this->db->where('IA.assistant_status', 'complete');
        $this->db->order_by('IA.date', 'ASC');
        return $this->db->get()->result();
    }

    public function get_patient_consultant_list($ipd_id, $patient_id)
    {
        $this->db->select('SUM(IC.quantity) as qty, IC.rate, IC.charge, SUM(IC.charge) as amount, GROUP_CONCAT(visit_date) as dates, D.name as consultant');
        $this->db->from('ipd_consultant_visits AS IC');
        $this->db->join('employees AS D', 'D.user_id = IC.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = D.user_id', 'left');
        $this->db->where('IC.ipd_id', $ipd_id);
        $this->db->where('IC.patient_id', $patient_id);
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('IC.visit_status', 'complete');
        $this->db->order_by('IC.visit_date', 'ASC');
        $this->db->group_by('IC.doctor_id');
        return $this->db->get()->result();
    }

    public function get_patient_charge_list($ipd_id, $patient_id)
    {
        $this->db->select('SUM(IC.quantity) as qty, IC.rate, IC.charge, SUM(IC.charge) as amount, GROUP_CONCAT(date) as dates, C.name as charge_name');
        $this->db->from('ipd_charges AS IC');
        $this->db->join('charges AS C', 'C.id = IC.charge_id', 'left');
        $this->db->where('IC.ipd_id', $ipd_id);
        $this->db->where('IC.patient_id', $patient_id);
        $this->db->where('IC.charge_status', 'complete');
        $this->db->order_by('IC.date', 'ASC');
        $this->db->group_by('IC.charge_id');
        return $this->db->get()->result();
    }

    public function get_print_list($id)
    {
        $this->db->select('IP.*, D.name as doctor, D.specialist, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address, P.guardian_name, P.marital_status, BG.name as ward_name, B.name as bed, F.name as floor, C.name as created_by');
        $this->db->from('ipd_patients AS IP');
        $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IP.doctor_id', 'left');
        $this->db->join('bed_groups AS BG', 'BG.id = IP.bed_group_id', 'left');
        $this->db->join('beds AS B', 'B.id = IP.bed_id', 'left');
        $this->db->join('floors AS F', 'F.id = BG.floor_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = IP.created_by', 'left');
        $this->db->where('IP.id', $id);
        return $this->db->get()->row();
    }

    public function get_single_surgeon($ipd_id, $patient_id)
    {
        $this->db->select('IS.*, D.name as doctor, D.specialist');
        $this->db->from('ipd_surgeons AS IS');
        $this->db->join('patients AS P', 'P.user_id = IS.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IS.doctor_id', 'left');
        $this->db->where('IS.ipd_id', $ipd_id);
        $this->db->where('IS.patient_id', $patient_id);
        $this->db->where('IS.surgeon_status', 'complete');
        return $this->db->get()->row();
    }

    public function get_single_anesthesia($ipd_id, $patient_id)
    {
        $this->db->select('IA.*, D.name as doctor, D.specialist');
        $this->db->from('ipd_anesthesias AS IA');
        $this->db->join('patients AS P', 'P.user_id = IA.patient_id', 'left');
        $this->db->join('anesthetists AS D', 'D.user_id = IA.doctor_id', 'left');
        $this->db->where('IA.ipd_id', $ipd_id);
        $this->db->where('IA.patient_id', $patient_id);
        $this->db->where('IA.anesthesia_status', 'complete');
        return $this->db->get()->row();
    }

    public function get_invoice_list($ipd_id, $invoice_id)
    {
        $this->db->select('ID.*');
        $this->db->from('ipd_invoice_details AS ID');
        $this->db->join('ipd_invoices AS I', 'I.id = ID.invoice_id', 'left');
        $this->db->where('ID.ipd_id', $ipd_id);
        $this->db->where('ID.invoice_id', $invoice_id);
        $this->db->order_by('ID.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_bill_list($limit, $offset, $search, $type, $form_date, $to_date, $count)
    {
        $this->db->select('IP.*, P.name as patient_name, P.patient_unique_id');
        $this->db->from('ipd_invoices AS IP');
        $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
        if ($search) {
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.name', $search, 'both');
            $this->db->or_like('P.phone', $search, 'both');
        }
        if ($type == 1) {
            $this->db->where('IP.paid_status', 'unpaid');
        }
        if ($type == 2) {
            $this->db->where('IP.paid_status', 'paid');
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(IP.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        $this->db->order_by('IP.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_payment_history_list($ipd_id, $invoice_id)
    {
        $this->db->select('P.*, C.name as created_by');
        $this->db->from('ipd_advance_payments AS P');
        $this->db->join('ipd_invoices AS I', 'I.ipd_id = P.ipd_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = P.created_by', 'left');
        $this->db->where('P.ipd_id', $ipd_id);
        $this->db->where('I.id', $invoice_id);
        $this->db->where('P.payment_status', 'complete');
        $this->db->order_by('P.id', 'DESC');
        return $this->db->get()->result();
    }
}
