<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Booking.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Booking
 * @description     : Manage IPD Bed Booking.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Booking extends MY_Controller
{

    public $data = array();

    function __construct()
    {
        parent::__construct();
        $this->load->model('Booking_Model', 'booking', true);
        $this->load->model('Ipd_Model', 'ipd', true);
    }

    public function index()
    {

        check_permission(VIEW);

        $type = $this->input->get('type') ?? 1;
        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        $config['base_url'] = current_url();
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->booking->get_booking_list($config['per_page'], $offset, $type, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['bookings'] = $this->booking->get_booking_list($config['per_page'], $offset, $type, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;
        $this->data['type'] = $type;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('bed') . ' ' . $this->lang->line('booking') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('ipd/booking/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add Booking" user interface
     *                    and process to store "bed_bookings" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function add()
    {

        check_permission(ADD);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('bed_group_id', $this->lang->line('bed') . ' ' . $this->lang->line('group'), 'trim|required');
            $this->form_validation->set_rules('bed_id', $this->lang->line('bed'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {

                $data['date'] = $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : date('Y-m-d H:i:s');
                $data['bed_group_id'] = $this->input->post('bed_group_id');
                $data['bed_id'] = $this->input->post('bed_id');
                $data['booking_id'] = $this->input->post('booking_id');
                if ($data['booking_id']) {
                    $data['booking_name'] = null;
                    $data['phone'] = null;
                } else {
                    $data['booking_name'] = $this->input->post('booking_name');
                    $data['phone'] = $this->input->post('phone');
                }

                $data['patient_id'] = $this->input->post('patient_id');
                if ($data['patient_id']) {
                    $data['patient_name'] = null;
                    $data['address'] = null;
                } else {
                    $data['patient_name'] = $this->input->post('name');
                    $data['address'] = $this->input->post('address');
                }
                $data['remark'] = $this->input->post('remark');
                $data['is_active'] = 1;
                $data['status'] = 1;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $insert_id = $this->booking->insert('bed_bookings', $data);
                if ($insert_id) {
                    $this->booking->update('beds', ['is_active' => 2], ['id' => $data['bed_id']]);
                    create_log('Has been created a bed booking : ' . $insert_id);
                    success($this->lang->line('insert_success'));
                    redirect('ipd/booking');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('ipd/booking/add');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['bed_groups'] = $this->ipd->get_bed_group_list();
        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('booking') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('ipd/booking/add', $this->data);
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Bed Booking Chart" user interface
     *                    with populate "Bed Booking Chart" value
     *                    and process to update "bed_bookings" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function edit()
    {

        check_permission(EDIT);

        if ($_POST) {


            $this->load->library('form_validation');
            $this->form_validation->set_rules('in_active', $this->lang->line('booking') . ' ' . $this->lang->line('status'), 'trim|required');
            $this->form_validation->set_rules('remark', $this->lang->line('remark'), 'trim');
            if ($this->form_validation->run() === TRUE) {
                $bed_booking = $this->booking->get_single('bed_bookings', array('id' => $this->input->post('id')));
                if ($this->input->post('in_active') == 2) {
                    $data['is_active'] = 2;
                    $data['remark'] = $this->input->post('remark');
                    $data['modified_at'] = date('Y-m-d H:i:s');
                    $data['modified_by'] = logged_in_user_id();
                    $this->booking->update('bed_bookings', $data, array('id' => $this->input->post('id')));
                    $this->booking->update('beds', ['is_active' => 0], array('id' => $bed_booking->bed_id));
                }
                create_log('Has been updated a bed booking : ' . $bed_booking->id);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('update_success'));
            } else {
                $msg = array(
                    'remark' => form_error('remark')
                );
                $array = array('status' => 'failed', 'error' => $msg, 'message' => '');
            }
            echo json_encode($array);
        }
    }

    /*     * ***************Function get_single_booking**********************************
     * @type            : Function
     * @function name   : get_single_booking
     * @description     : "Load single booking information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_booking()
    {
        $id = $this->input->post('id');
        $this->data['booking'] = $this->booking->get_single_booking($id);
        echo $this->load->view('ipd/booking/view', $this->data);
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Booking" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null)
    {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect($_SERVER['HTTP_REFERER']);
        }

        $bed_booking = $this->booking->get_single('bed_bookings', array('id' => $id));
        if ($this->booking->delete('bed_bookings', array('id' => $id))) {
            $this->booking->update('beds', ['is_active' => 0], ['id' => $bed_booking->bed_id]);
            create_log('Has been deleted a bed booking : ' . $bed_booking->id);
            create_log('Has been remove by bed booking : ' . $bed_booking->id . ' and bed id: ' . $bed_booking->bed_id);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function employee()
    {
        $employee = $this->booking->get_employee($this->input->get('q'));
        echo json_encode($employee);
    }

    public function patient()
    {
        $patient = $this->booking->get_patient($this->input->get('q'));
        echo json_encode($patient);
    }
}
