<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Holiday_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }
    
    public function get_holiday_list($limit, $offset, $keyword, $form_date, $to_date,  $created_by, $count) {
        $this->db->select('H.*');
        $this->db->from('holidays AS H');
        if ($keyword) {
            $this->db->like('H.title', $keyword, 'both');
            $this->db->or_like('H.bn_title', $keyword, 'both');
            $this->db->or_like('H.remark', $keyword, 'both');
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(H.from_date) AND DATE(H.to_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($created_by) {
            $this->db->where('H.created_by', $created_by);
        }
        $this->db->order_by('H.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_holiday($id) {
        $this->db->select('H.*, C.name as created_by, M.name as modified_by');
        $this->db->from('holidays AS H');
        $this->db->join('employees AS C', 'C.user_id = H.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = H.modified_by', 'left');
        $this->db->where('H.id', $id);
        return $this->db->get()->row();
    }

    function duplicate_check($date_from, $title, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where("DATE(from_date)", $date_from);
        $this->db->where('title', $title);
        return $this->db->get('holidays')->num_rows();
    }
}
