<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Designation_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_designation_list($limit, $offset, $search, $count) {
        $this->db->select('D.*, DP.name as department, DP.bn_name as department_bn');
        $this->db->from('designations AS D');
        $this->db->join('departments AS DP', 'DP.id = D.department_id', 'left');
        if ($search) {
            $this->db->like('D.name', $search, 'both');
            $this->db->or_like('D.bn_name', $search, 'both');
            $this->db->or_like('D.note', $search, 'both');
            $this->db->or_like('DP.name', $search, 'both');
        }
        $this->db->order_by('D.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check($name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('designations')->num_rows();
    }
}
