<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('test'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_test'); ?>
        </h4>

        <div class="align-items-center">
            <?php if (has_permission(VIEW, 'hospital', 'diagnostic')) { ?>
                <a href="<?php echo site_url('hospital/diagnostic/department'); ?>" class="btn btn-xs btn-info">
                    <i class="fa fa-building font-12 mr-5"></i>
                    <?php echo $this->lang->line('department'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'hospital', 'diagnostic')) { ?>
                <a href="<?php echo site_url('hospital/diagnostic/group'); ?>" class="btn btn-xs btn-primary">
                    <i class="fa fa-group font-12 mr-5"></i>
                    <?php echo $this->lang->line('group'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'hospital', 'diagnostic')) { ?>
                <a href="<?php echo site_url('hospital/diagnostic/test'); ?>" class="btn btn-xs btn-warning">
                    <i class="fa fa-h-square font-12 mr-5"></i>
                    <?php echo $this->lang->line('test'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'hospital', 'diagnostic')) { ?>
                <a href="<?php echo site_url('hospital/diagnostic/tube'); ?>" class="btn btn-xs btn-indigo">
                    <i class="fa fa-flask font-12 mr-5"></i>
                    <?php echo $this->lang->line('tube'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <!-- Search Start-->
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('hospital/diagnostic/price'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?></label>
                            <select class="form-control select2" name="department_id" id="department_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($department_id) && $department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="group_id"><?php echo $this->lang->line('group'); ?></label>
                            <select class="form-control select2" name="group_id" id="group_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($groups as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($group_id) && $group_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
            <!-- Search End-->

            <?php if (isset($tests) && !empty($tests)) { ?>
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-h-square font-30 mr-10"></i>
                                <?php echo $this->lang->line('test'); ?> <?php echo $this->lang->line('test'); ?>
                            </h6>
                        <?php } ?>
                    </div>
                    <?php echo form_open_multipart(site_url('hospital/diagnostic/price'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th width="15%"><?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('code'); ?></th>
                                            <th><?php echo $this->lang->line('room_no'); ?></th>
                                            <th width="10%"><?php echo $this->lang->line('specimen'); ?></th>
                                            <th><?php echo $this->lang->line('rate'); ?></th>
                                            <th><?php echo $this->lang->line('discount'); ?></th>
                                            <th><?php echo $this->lang->line('mbbs'); ?></th>
                                            <th><?php echo $this->lang->line('vd'); ?></th>
                                            <th><?php echo $this->lang->line('emp'); ?></th>
                                            <th><?php echo $this->lang->line('corporate'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $sl = 1;
                                        foreach ($tests as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl++; ?></td>
                                                <td>
                                                    <?php echo $obj->name; ?>
                                                    <input type="hidden" name="test_id[]" value="<?php echo $obj->id; ?>">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="code" name="code[<?php echo $obj->id; ?>]" value="<?php echo $obj->code; ?>" placeholder="<?php echo $this->lang->line('code'); ?>" autocomplete="off">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="room_no" name="room_no[<?php echo $obj->id; ?>]" value="<?php echo $obj->room_no; ?>" placeholder="<?php echo $this->lang->line('room_no'); ?>" autocomplete="off">
                                                </td>
                                                <td>
                                                    <select class="form-control custom-select" name="specimen[<?php echo $obj->id; ?>]" id="specimen">
                                                        <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                                        <?php $specimens = get_specimen(); ?>
                                                        <?php foreach ($specimens as $key => $value) { ?>
                                                            <option value="<?php echo $key; ?>" <?php echo isset($obj->specimen) && $obj->specimen == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="rate" name="rate[<?php echo $obj->id; ?>]" value="<?php echo $obj->rate; ?>" placeholder="<?php echo $this->lang->line('rate'); ?>" autocomplete="off">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="special_discount" name="special_discount[<?php echo $obj->id; ?>]" value="<?php echo $obj->special_discount; ?>" placeholder="<?php echo $this->lang->line('special'); ?> <?php echo $this->lang->line('discount'); ?>" autocomplete="off">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="mbbs" name="mbbs[<?php echo $obj->id; ?>]" value="<?php echo $obj->mbbs; ?>" placeholder="<?php echo $this->lang->line('mbbs'); ?>" autocomplete="off">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="vd" name="vd[<?php echo $obj->id; ?>]" value="<?php echo $obj->vd; ?>" placeholder="<?php echo $this->lang->line('vd'); ?>" autocomplete="off">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="emp" name="emp[<?php echo $obj->id; ?>]" value="<?php echo $obj->emp; ?>" placeholder="<?php echo $this->lang->line('emp'); ?>" autocomplete="off">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control form-control-sm" id="corporate" name="corporate[<?php echo $obj->id; ?>]" value="<?php echo $obj->corporate; ?>" placeholder="<?php echo $this->lang->line('corporate'); ?>" autocomplete="off">
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- Card Footer -->
                    <div class="card-footer pt-0">
                        <div class="button-list">
                            <a class="btn btn-gradient-danger" href="<?php echo site_url('hospital/diagnostic'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                            <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            <?php } ?>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
</script>